# -*- coding: utf-8 -*-
from travel.avia.library.python.common.settings import *

from travel.avia.library.python.environment_helpers.env_variable_provider import EnvironmentVariableProvider


SERVICE_NAME = 'AVIA_API'
env_variable_provider = EnvironmentVariableProvider(SERVICE_NAME)

YT_TOKEN = os.getenv('YT_TOKEN')
YT_PROXY = os.getenv('YT_PROXY')
APP_PATH = os.path.normpath(os.path.abspath(
    os.path.join(os.path.dirname(__file__), '..')
))
PROJECT_PATH = os.path.dirname(APP_PATH)

CACHE_PATH = '/var/cache/yandex-avia-api'

DEBUG = False
FLASK_DEBUG = False

ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)

MANAGERS = ADMINS

SENTRY_DSN = None

ROOT_URLCONF = None

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'
USE_TZ = True

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale.
USE_L10N = True

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = ''

# Используем загружаемую статику расписаний
RASP_MEDIA_URL = 'https://yastatic.net/rasp/media/'
DEFAULT_FILE_STORAGE = 'travel.avia.avia_api.avia.lib.storage.RaspFileSystemStorage'

# Absolute path to the directory static files should be collected to.
# Don't put anything in this directory yourself; store your static files
# in apps' "static/" subdirectories and in STATICFILES_DIRS.
# Example: "/home/media/media.lawrence.com/static/"
STATIC_ROOT = ''

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

# List of finder classes that know how to find static files in
# various locations.
STATICFILES_FINDERS = [
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
    # 'django.contrib.staticfiles.finders.DefaultStorageFinder',
]

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'e)q36xhlc$c$50c$nbre^8^55hb=7l1q57+h63dme^g*&amp;j8=)n'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    # 'django.template.loaders.filesystem.Loader',
    # 'django.template.loaders.app_directories.Loader',
    # 'django.template.loaders.eggs.Loader',
)

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'APP_DIRS': True,
        'DIRS': [],
    },
]

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    # Uncomment the next line for simple clickjacking protection:
    # 'django.middleware.clickjacking.XFrameOptionsMiddleware',
)

ALLOWED_HOSTS = ['*']

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    # Uncomment the next line to enable the admin:
    # 'django.contrib.admin',
    # Uncomment the next line to enable admin documentation:
    # 'django.contrib.admindocs',
    'travel.avia.library.python.avia_data',
    'travel.avia.library.python.avia_data.django_commands',
    'travel.avia.library.python.common',
    'travel.avia.library.python.common.xgettext',
    'travel.avia.library.python.common.app_stubs.www',
    'travel.avia.library.python.common.app_stubs.currency',
    'travel.avia.library.python.common.app_stubs.order',
    'raven.contrib.django.raven_compat'
)

APIKEYS_URL = env_variable_provider.get('APIKEYS_URL', required=False)
APIKEYS_TIMEOUT = 1
APIKEYS_SERVICE_TOKEN = env_variable_provider.get('APIKEYS_SERVICE_TOKEN', required=False)

# ivanovs-4@yandex.ru
# Получил здесь https://developer.test1f.tech.yandex.ru
APIKEYS_DEBUG_YKEY = '4c15b22b-ef95-47b3-84c3-0ea36d5ac13a'

INTERNAL_API_USERNAME = 'api_pilot'
INTERNAL_API_PASSWORD = env_variable_provider.get('INTERNAL_API_PASSWORD', required=False)

INTERNAL_API_APP_USERNAME = 'avia_app_pilot'
INTERNAL_API_APP_PASSWORD = env_variable_provider.get('INTERNAL_API_APP_PASSWORD', required=False)

SOVETNIK_API_USERNAME = 'sovetnik'
SOVETNIK_API_PASSWORD = env_variable_provider.get('SOVETNIK_API_PASSWORD', required=False)

AFL_SEARCH_API_USERNAME = 'afl_search'
AFL_SEARCH_API_PASSWORD = env_variable_provider.get('AFL_SEARCH_API_PASSWORD', required=False)

MONGO_USER = None
MONGO_PASSWORD = None
MONGO_DATABASE = 'avia_api'

BILLING_PLATFORM_IOS = 503             # 503 - приложение Авиабилетов под iOS
BILLING_PLATFORM_ANDROID = 504         # 504 - приложение Авиабилетов под андроид
BILLING_PLATFORM_WINDOWS_PHONE = 505   # 505 - приложение Авиабилетов windows phone
BILLING_PLATFORM_IPAD = 506            # 506 - приложение Авиабилетов для ipad
BILLING_PLATFORM_ANDROID_TABLET = 507  # 507 - приложение Авиабилетов для android tablet

BILLING_PLATFORMS = {
    # приложение Авиабилетов под iOS (503)
    'ios': BILLING_PLATFORM_IOS,

    # приложение Авиабилетов под андроид (504)
    'android': BILLING_PLATFORM_ANDROID,

    # приложение Авиабилетов windows phone (505)
    'wphone': BILLING_PLATFORM_WINDOWS_PHONE,

    # приложение Авиабилетов для ipad (506)
    'ios_tablet': BILLING_PLATFORM_IPAD,

    # приложение Авиабилетов для android tablet (507)
    'android_tablet': BILLING_PLATFORM_ANDROID_TABLET,

    # приложение Авиабилетов на IOS для внутреннего пользования. Ключ назван
    # Key #5, потому что не смогли дать название при создании. При переработке
    # названия ключа в название платформы Key #5 превращается в key.
    # https://st.yandex-team.ru/APIKEYS-214
    'key': BILLING_PLATFORM_IOS,
}
FALLBACK_PLATFORM = 'key'
assert FALLBACK_PLATFORM in BILLING_PLATFORMS

# Pusher settings
PUSHER_PLATFORMS = (
    'android',
    'android_tablet',
    'ios',
    'ios_tablet',
    'key',
    'wphone',
)
assert (
    sorted(BILLING_PLATFORMS.keys()) ==
    sorted(PUSHER_PLATFORMS)
)


class PusherData(object):
    def __init__(self, platform, application):
        self.platform = platform
        self.application = application


PUSHER_DATAS = {
    'android':
        PusherData('a', 'ru.yandex.mobile.avia'),
    'android_tablet':
        PusherData('a', 'ru.yandex.mobile.avia'),
    'ios':
        PusherData('i', 'ru.yandex.mobile.avia'),
    'ios_tablet':
        PusherData('i', 'ru.yandex.mobile.avia'),
    'key':
        PusherData('i', 'ru.yandex.mobile.avia.inhouse'),
    'wphone':
        PusherData('mpns', 'wildcard.mobile.yandex.net.production'),
}
assert (
    sorted(PUSHER_PLATFORMS) ==
    sorted(PUSHER_DATAS.keys())
)

# Xiva settings
XIVA_APP_NAME = {
    'default': 'ru.yandex.mobile.avia.inhouse',
    'gcm': 'ru.yandex.mobile.avia',
}
XIVA_HOST = env_variable_provider.get('XIVA_HOST', required=False)
XIVA_SEND_TOKEN = env_variable_provider.get('XIVA_SEND_TOKEN', required=False)
XIVA_SUBSCRIBE_TOKEN = env_variable_provider.get('XIVA_SUBSCRIBE_TOKEN', required=False)
XIVA_SERVICE = 'avia'
XIVA_DEVICE_TYPES = {
    'android': 'gcm',
    'android_tablet': 'gcm',
    'ios': 'apns',
    'ios_tablet': 'apns',
    'wphone': 'mpns',
    'key': 'apns',  # service: tours
}

BLACKBOX_TIMEOUT = 1

TANKER_TOKENS = {
    # https://tanker.yandex-team.ru/keysets/?project-id=avia-api&branch-id=master
    'stable': '4378d81ff774443988e18b3cc6ff3205',
    # https://tanker-test.yandex-team.ru/keysets/?project-id=avia-api
    'testing': 'be8c745ed16e407f8e5a1a1b64ac57b2',
}

# TANKER_KEYSETS = {}

XGETTEXT_KEYSETS = {
    'avia_v1': {
        'filename': 'travel/avia/avia_api/avia/keyset.json',
        'dirs': [
            'avia/v1/views',
            'avia/v1/sovetnik',
            'avia/lib',
        ]
    }
}

FAKE_API_KEYS = False
FAKE_CURRENCY_RATES = False

FRONTEND_URLS = {
    'ru': 'https://avia.yandex.ru',
    'ua': 'https://avia.yandex.ua',
    'kz': 'https://avia.yandex.kz',
    'tr': 'https://bilet.yandex.com.tr',
    'com': 'https://flights.yandex.com',
}

TRAVEL_FRONTEND_URLS = {
    'ru': 'https://travel.yandex.ru',
}

TRAVEL_TEST_FRONTEND_URLS = {
    'ru': 'https://travel-test.yandex.ru',
}
