# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from django.conf import settings
from flask import Blueprint

from travel.avia.avia_api.avia.lib.flask_authdigest import FlaskRealmDigestDB
import travel.avia.avia_api.ant.api_interface


afl_search_blueprint = Blueprint('afl_search_v1', __name__)

afl_search_auth_db = FlaskRealmDigestDB(
    realm='AFLSearchApi',
    users=[
        (
            settings.AFL_SEARCH_API_USERNAME,
            settings.AFL_SEARCH_API_PASSWORD,
        ),
    ]
)

afl_search_api = travel.avia.avia_api.ant.api_interface.Ant(
    afl_search_blueprint,
    auth_decorator=afl_search_auth_db.requires_auth,
)
