# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import logging

from django.conf import settings

from travel.avia.avia_api.ant.api_interface import ViewParam
from travel.avia.avia_api.ant.custom_types import Bool, DateStr, SettlementGeoIdToStationIdList
from travel.avia.avia_api.avia.lib.jsend import ApiFail

from travel.avia.avia_api.avia.lib.shared_flights import shared_flights
from travel.avia.avia_api.avia.v1.afl_search.api import afl_search_api
from travel.avia.avia_api.avia.v1.afl_search.schemas import AFLSearchResponseSchema, AFLVariantsResponseSchema


log = logging.getLogger(__name__)


@afl_search_api.view('/flights-network/', disable_auth_in_environments=['development'])
@afl_search_api.result_schema(AFLSearchResponseSchema)
def afl_search_handler(
    schema_context=None,
):
    try:
        response = shared_flights.get_flights_network(['SU', 'FV'])

        return response
    except Exception as e:
        raise ApiFail(e)


@afl_search_api.view('/connecting-variants/', disable_auth_in_environments=['development'])
@afl_search_api.result_schema(AFLVariantsResponseSchema)
def afl_variants_handler(
    depart_from=ViewParam(name='from', type_=SettlementGeoIdToStationIdList()),
    arrive_to=ViewParam(name='to', type_=SettlementGeoIdToStationIdList()),
    after=ViewParam(name='after', type_=DateStr(), required=False),
    before=ViewParam(name='before', type_=DateStr(), required=False),
    one_way=ViewParam(name='one-way', type_=Bool(), required=False),
    national_version=ViewParam(choices=[version for version in settings.NATIONAL_VERSIONS], required=False),
    schema_context=None,
):
    try:
        response = shared_flights.get_aeroflot_variants(
            depart_from,
            arrive_to,
            after,
            before,
            national_version,
            one_way,
        )

        return response
    except Exception as e:
        raise ApiFail(e)
