# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from logging import getLogger

from travel.avia.avia_api.avia.v1.schemas import fields, ApiSchema
from travel.avia.library.python.common.models.geo import Station, Settlement

LANG_RU = 'ru'

log = getLogger(__name__)


class AFLSearchSettlemenSchema(ApiSchema):
    title = fields.Method('get_settlement_title', required=False)
    countryID = fields.Method('get_settlement_country', required=False)
    geoID = fields.Method('get_settlement_geo_id', required=False)

    def get_settlement_title(self, settlement_id):
        return (
            Settlement.objects
                .get(pk=settlement_id)
                .L_title(lang=LANG_RU)
        )

    def get_settlement_country(self, settlement_id):
        return (
            Settlement.objects
                .get(pk=settlement_id)
                .country_id
        )

    def get_settlement_geo_id(self, settlement_id):
        return (
            Settlement.objects
                .get(pk=settlement_id)
                ._geo_id
        )


class AFLSearchStationSchema(ApiSchema):
    stationID = fields.Integer(attribute='airportID', required=True)
    settlementID = fields.Integer(required=False)
    iata = fields.String(required=False)
    icao = fields.String(required=False)
    sirena = fields.String(required=False)
    settlement = fields.Nested(AFLSearchSettlemenSchema, attribute='settlementID', required=False)
    stationTitle = fields.Method('get_station_title', required=False)

    def get_station_title(self, station):
        return (
            Station.objects
                .get(pk=station['airportID'])
                .L_title(lang=LANG_RU)
        )


class AFLSearchResponseSchema(ApiSchema):
    airlines = fields.List(fields.Integer(required=True))
    stations = fields.List(fields.Nested(AFLSearchStationSchema, required=True))


class AFLVariantFlightSchema(ApiSchema):
    airlineID = fields.Integer(load_from='airlineID', required=True)
    number = fields.String(load_from='number', required=True)
    title = fields.String(load_from='title', required=True)
    departureDatetime = fields.String(load_from='departureDatetime', required=True)
    departureTerminal = fields.String(load_from='departureTerminal', required=False)
    departureStation = fields.Integer(load_from='departureStation', required=True)
    arrivalDatetime = fields.String(load_from='arrivalDatetime', required=True)
    arrivalTerminal = fields.String(load_from='arrivalTerminal', required=False)
    arrivalStation = fields.Integer(load_from='arrivalStation', required=True)
    transportModelID = fields.Integer(load_from='transportModelID', required=False)


class AFLVariantSliceSchema(ApiSchema):
    flights = fields.List(fields.Nested(AFLVariantFlightSchema))
    duration = fields.Integer(load_from='duration', required=True)


class AFLVariantsSchema(ApiSchema):
    forward = fields.Nested(AFLVariantSliceSchema, attribute='forward', required=True)
    backward = fields.Nested(AFLVariantSliceSchema, attribute='backward', required=False)


class AFLVariantsResponseSchema(ApiSchema):
    departureStations = fields.List(fields.Integer(required=True))
    arrivalStations = fields.List(fields.Integer(required=True))
    variants = fields.List(fields.Nested(AFLVariantsSchema))
