# -*- coding: utf-8 -*-
import logging
import sys

import decorator


@decorator.decorator
def stdout_logger(fn, *args, **kwargs):
    console = logging.StreamHandler(sys.stdout)
    console.setLevel(logging.INFO)
    logging.getLogger('').addHandler(console)
    try:
        return fn(*args, **kwargs)
    finally:
        logging.getLogger('').removeHandler(console)


def forbidden_environments(environments):
    @decorator.decorator
    def forbidden_environments_decorator(fn, *args, **kwargs):
        from django.conf import settings

        print('Check environment type "%s" not in %s' % (settings.YANDEX_ENVIRONMENT_TYPE, environments))
        if settings.YANDEX_ENVIRONMENT_TYPE not in environments:
            return fn(*args, **kwargs)
        else:
            print('Cannot execute in environment %s, should be one of %s' % (
                settings.YANDEX_ENVIRONMENT_TYPE,
                environments
            ))

    return forbidden_environments_decorator
