# -*- coding: utf-8 -*-
import logging

from django.conf import settings
from yt.wrapper import YtClient

from travel.avia.avia_api.avia.lib.mongo_iterator import iterate_chunks
from travel.avia.avia_api.avia.v1.email_dispenser.commands.decorators import stdout_logger
from travel.avia.avia_api.avia.v1.email_dispenser.helpers.yt_cache import PopularVariants, QkeyMinPrice
from travel.avia.avia_api.avia.v1.email_dispenser.variants_fetcher.runme import ensure_recent_computations
from travel.avia.avia_api.avia.v1.model.subscriber import Subscription

log = logging.getLogger(__name__)


@stdout_logger
def update_subscriptions():
    log.info('Start updating subscriptions')

    try:
        actualize_subscriptions()

        ytc = YtClient(
            token=settings.YT_TOKEN,
            proxy=settings.YT_PROXY,
            config={
                'remote_temp_tables_directory': '//home/avia/tmp',
            },
        )
        recent_computation = ensure_recent_computations(ytc, relevant_subscriptions(), log)
        min_price_qkey_table = recent_computation.min_prices_qkey_table
        min_price_provider = QkeyMinPrice(ytc, min_price_qkey_table)
        popular_variants_provider = PopularVariants(ytc, recent_computation.popular_variants_table)

        for subscription in relevant_subscriptions():
            try:
                subscription.update_min_price(
                    minprice_provider=min_price_provider,
                    popular_provider=popular_variants_provider,
                )
                log.info('Min prices updated for %r', subscription)
            except Exception:
                log.exception('Error updating min prices for %r', subscription)

    except Exception:
        log.exception('Got an error while updating minimal prices')
        raise

    log.info('Minimal prices updated successfully')


def relevant_subscriptions():
    for subscription in iterate_chunks(Subscription, 'qkey', Subscription.objects.all().no_cache()):
        try:
            if subscription.is_relevant():
                yield subscription
        except AttributeError:
            log.exception('Bad subscription %r, skipping', subscription)


def actualize_subscriptions():
    for subscription in iterate_chunks(Subscription, 'qkey', Subscription.objects.all().no_cache()):
        try:
            if not subscription.is_relevant():
                subscription.delete()
                log.info('Delete outdated subscription %r', subscription)
        except AttributeError:
            log.exception('Bad subscription %r, skipping', subscription)
