# coding=utf-8
from __future__ import unicode_literals

CURRENCY_TO_CODE_MAP = {
    'RUR': '\u20bd',
    'RUB': '\u20bd',
    'USD': '$',
    'EUR': '\u20AC',
    'UAH': '\u20B4',
    'KZT': '\u20B8',
    'BYN': 'Br',
    'MDL': 'L',
    'TRY': '\u20BA',
}


def currency_to_symbol(currency_code):
    """
    :param text_type currency_code:
    :rtype: text_type
    """
    return CURRENCY_TO_CODE_MAP.get(currency_code, currency_code)
