# -*- coding: utf-8 -*-

from cachetools.func import lru_cache

from travel.avia.library.python.avia_data.models import Currency, TopFlight
from travel.avia.library.python.common.models.schedule import Company


def get_popularity_map(qkey_params_set):
    """
    Принимаем набор ключей вида (from_point_key, to_point_key, day_of_week, national_version)
    и выдаём обратно dict с ключами вида (from_point_key, to_point_key, day_of_week, national_version, flights)
    и популярностью в значении

    :param List[Tuple[str, str, int, str]] qkey_params_set: параметры для поиска попялурностей
    :rtype: Dict[Tuple[str, str, int, str, str]]
    """
    top_flights = TopFlight.objects.all()
    popularity = {}
    for flight in top_flights:
        from_point_key = flight.from_point_key
        to_point_key = flight.to_point_key
        day_of_week = flight.day_of_week
        national_version = flight.national_version
        flights = flight.flights
        redirects = flight.redirects

        if (from_point_key, to_point_key, day_of_week, national_version) in qkey_params_set:
            popularity[(from_point_key, to_point_key, day_of_week, national_version, flights)] = redirects
    return popularity


class AviaDataCurrencyCache(object):
    def __init__(self):
        self.cache = None

    @property
    def by_id(self):
        if self.cache is None:
            cache = {}
            currency_db = Currency.objects.all()
            for currency in currency_db:
                cache[currency.id] = currency
            self.cache = cache
        return self.cache


avia_data_currency_cache = AviaDataCurrencyCache()


@lru_cache(maxsize=None)
def get_company_avatar(company_id):
    """
    :param int company_id:
    :rtype: basestring | None
    """
    try:
        return Company.objects.get(id=company_id).svg2png_logo2.url
    except (ValueError, AttributeError):
        pass
    return None
