# -*- coding: utf-8 -*-
from travel.avia.avia_api.avia.v1.email_dispenser.helpers.variants_filter import VariantsFilter


def _plain_variants_data(min_prices, top_variants):
    if not min_prices or not top_variants:
        return None
    minprice_section_variant_data = min_prices[:1]
    if not minprice_section_variant_data:
        return None
    popular_section_variants_data = [
        v for v in top_variants[:4] if v not in minprice_section_variant_data
    ]

    return {
        'min_price_variant_data': minprice_section_variant_data,
        'popular_section_variants_data': popular_section_variants_data,
        'other_data': None,
    }


def _filtered_variants_data(min_prices, top_variants, _filter):
    if not min_prices or not top_variants:
        return None
    vf = VariantsFilter(_filter)
    minprice_section_variant_data = filter(vf.test, min_prices)[:1]
    if not minprice_section_variant_data:
        return None
    popular_section_variants_data = [
        v for v in filter(vf.test, top_variants)[:4] if v not in minprice_section_variant_data
    ]

    other_section_variants_data = [
        v for v in top_variants[:8] if
        v not in minprice_section_variant_data and v not in popular_section_variants_data
    ]

    return {
        'min_price_variant_data': minprice_section_variant_data,
        'popular_section_variants_data': popular_section_variants_data[:3],
        'other_data': other_section_variants_data[:3],
    }


def combine_variants_data(min_prices, top_variants, _filter=None):
    if _filter is None:
        return _plain_variants_data(min_prices, top_variants)
    else:
        return _filtered_variants_data(min_prices, top_variants, _filter)
