# -*- coding: utf-8 -*-
from datetime import datetime, timedelta


def single_item_putter(dic, key, value):
    dic[key] = value


def list_item_putter(dic, key, value):
    if key not in dic:
        dic[key] = []
    dic[key].append(value)


class YtCache(object):
    def __init__(self, yt, yt_table):
        self.yt = yt
        self.yt_table = yt_table
        self.cache = None

    def precache(self, cache_key, value_putter):
        if self.cache is None:
            cache = {}
            stations_iterator = self.yt.read_table(self.yt_table)
            for s in stations_iterator:
                key = s[cache_key]
                value_putter(cache, key, s)
            self.cache = cache


class Station(YtCache):
    def __init__(self, yt, station_table='//home/rasp/reference/station'):
        super(Station, self).__init__(yt, station_table)

    @property
    def by_id(self):
        self.precache('id', single_item_putter)
        return self.cache


class Company(YtCache):
    def __init__(self, yt, company_table='//home/rasp/reference/company'):
        super(Company, self).__init__(yt, company_table)

    @property
    def by_id(self):
        self.precache('id', single_item_putter)
        return self.cache


class QkeyMinPrice(YtCache):
    @property
    def by_qkey(self):
        self.precache('qkey', list_item_putter)
        return self.cache


class PopularVariants(YtCache):
    @property
    def by_qkey(self):
        self.precache('qkey', list_item_putter)
        return self.cache


def last_logs_tables(yt, path, days):
    today = datetime.now().date()
    return safe_tables_for_daterange(yt, path, today - timedelta(days), today)


def _table_date(table):
    return datetime.strptime(table.split('/')[-1], '%Y-%m-%d').date()


def safe_tables_for_daterange(yt, path, begin, end):
    tables = []
    for t in yt.search(path, node_type='table'):
        try:
            if begin <= _table_date(t) <= end:
                tables.append(t)
        except:
            continue

    return tables
