# -*- coding: utf-8 -*-
import logging
import json
from urlparse import urljoin

import requests
from django.conf import settings
from retrying import retry

log = logging.getLogger(__name__)


class TransactionalApi(object):
    def __init__(self, settings, campaign_slug):
        self.url = '{host}/api/0/{account_slug}/transactional/{campaign_slug}/'.format(
            host=settings.host, account_slug=settings.account_slug,
            campaign_slug=campaign_slug
        )
        self.auth = settings.auth

    @retry(stop_max_attempt_number=3, wait_fixed=2000)
    def send(self, to_email, args, async_send=True, from_name=None, from_email=None,
             countdown=None, expires=None, attachments=None):
        """

        NOTE: from_email, from_name - (это нужно в редких кейсах; обычно лучше использовать адрес, прописанный в шаблоне Рассылятора)
        :param basestring to_email: куда отправлять. См. также пункт "Отправка на uid"
        :param dict args: json с переменными, которые будут подставлены в тело письма
        :param bool async_send: отправить письмо сразу (синхронно, без очереди) или положить в очередь
        :param from_name: заменить имя отправителя, прописанное в шаблоне
        :param from_email: заменить адрес отправителя, прописанный в шаблоне
        :param basestring|int countdown: для асинхронной отправки - отправить рассылку не сразу, а через countdown секунд.
        :param basestring|int expires: для асинхронной отправки - не отправлять через expires секунд. через какое время уже не нужно отправлять письмо.
        :param attachments: приаттачить эти файлы к письму
        :return:
        """
        data = {
            'to_email': to_email,
            'args': json.dumps(args),
            'async': async_send,
            'from_name': from_name,
            'from_email': from_email,
            'countdown': self._to_sec_str(countdown) if countdown else None,
            'expires': self._to_sec_str(expires) if expires else None,
            'attachments': attachments,
        }

        url = urljoin(self.url, 'send')
        if settings.YANDEX_ENVIRONMENT_TYPE == 'production':
            r = requests.post(url, auth=self.auth, data=data, verify=False)
        else:
            r = requests.post(url, auth=self.auth, data=data, verify=False)

        if not r.ok:
            raise Exception(
                'Send %s failed. Sender reponse %s, [%s]. Data: %r' % (
                    url,
                    r.status_code,
                    r.content,
                    data,
                )
            )
        return r

    @staticmethod
    def _to_sec_str(x):
        return '{}s'.format(x)
