# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.conf import settings
from flask import Blueprint

import travel.avia.avia_api.ant.api_interface
from travel.avia.avia_api.avia.lib.flask_authdigest import FlaskRealmDigestDB


internal_blueprint = Blueprint('internal_v1', __name__)

internal_auth_db = FlaskRealmDigestDB(
    realm='ApiAviaInternal',
    users=[
        (
            settings.INTERNAL_API_USERNAME,
            settings.INTERNAL_API_PASSWORD
        ), (
            settings.INTERNAL_API_APP_USERNAME,
            settings.INTERNAL_API_APP_PASSWORD
        ),
    ]
)

internal_api = travel.avia.avia_api.ant.api_interface.Ant(
    internal_blueprint,
    auth_decorator=internal_auth_db.requires_auth,
)
