# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

import travel.avia.avia_api.ant
import travel.avia.avia_api.ant.api_interface
import travel.avia.avia_api.ant.custom_types
import travel.avia.avia_api.ant.exceptions
from travel.avia.avia_api.ant.api_interface import ViewParam
from travel.avia.avia_api.avia.v1.model.user import User
from travel.avia.avia_api.avia.v1.schemas import fields, ApiSchema, UserFlightSchema
from travel.avia.avia_api.avia.v1.views.favorites import FavoriteSchema
from travel.avia.avia_api.avia.v1.internal.api import internal_api

log = logging.getLogger(__name__)


class UserByYandexUid(travel.avia.avia_api.ant.custom_types.ArgType):
    """ User by yandex_uid """
    def clean(self, raw):
        try:
            return User.objects.get(yandex_uid=raw)
        except Exception:
            raise travel.avia.avia_api.ant.exceptions.ValidationError('No user with yandex_uid %r' % raw)


class UserByUuid(travel.avia.avia_api.ant.custom_types.ArgType):
    """ User by uuid """
    def clean(self, raw):
        try:
            return User.objects.get(uuid=raw)
        except Exception:
            raise travel.avia.avia_api.ant.exceptions.ValidationError('No user with uuid %r' % raw)


class UserViewSchema(ApiSchema):
    uuid = fields.String()
    yandex_uid = fields.String()
    flights = fields.Nested(UserFlightSchema, many=True)
    aeroex_notify_flights = fields.Nested(UserFlightSchema, many=True)
    touched = fields.DateTime(format='%Y-%m-%d %H:%M:%S')
    favorites = fields.Nested(FavoriteSchema, many=True, exclude=['filter'])

    class Meta:
        ordered = True


@internal_api.view('/inspect/ya_user/')
@internal_api.result_schema(UserViewSchema)
def ya_user(
    user=ViewParam(name='yandex_uid', type_=UserByYandexUid()),
    schema_context=None
):
    return user


@internal_api.view('/inspect/uuid_user/')
@internal_api.result_schema(UserViewSchema)
def uuid_user(
    user=ViewParam(name='uuid', type_=UserByUuid()),
    schema_context=None
):
    return user


@internal_api.view('/inspect/user/list/')
def user_list():
    return User.objects
