# -*- coding: utf-8 -*-
import logging

from travel.avia.avia_api.avia.v1.model.db import db

log = logging.getLogger(__name__)


class Device(db.Document):
    meta = {
        'indexes': [
            {
                'fields': ['uuid'],
                'unique': True,
                'sparse': True
            }, {
                'fields': ['user'],
            }
        ],
        'index_background': True,
    }

    user = db.ReferenceField('User', required=True)
    uuid = db.StringField()  # ideally a null for a first winphone login
    platform = db.StringField(required=True)
    lang = db.StringField(required=True)  # ISO 639-1 language code
    country = db.StringField(required=True)  # ISO 3166-1 country code
    push_token = db.StringField()
    transport = db.StringField()

    def assign_to_user_and_save(self, user):
        if self.user:
            if self not in self.user.devices:
                log.error(u'User %r has no device %r', self.user, self)

            if self.id:
                self.user.update(pull__devices=self)
            else:
                log.info(
                    u'Device %r is not saved yet but is assingned to %r',
                    self, self.user
                )

        if (not self.user) or (self.user != user):
            log.info(u'Device %r has changed its user: %r -> %r',
                     self, self.user, user)

        self.user = user
        self.save()

        user.update(add_to_set__devices=self)

    def is_first_winphone_launch(self):
        if self.uuid and self.uuid.startswith('a' * 8):
            if self.platform == 'wphone':
                return True

            log.error(u'Bad uuid/platform by %r: %r/%r',
                      self, self.uuid, self.platform)
        return False
