# -*- coding: utf-8 -*-
import logging
from datetime import datetime
from functools import wraps

from travel.avia.contrib.python.mongoengine.mongoengine.errors import NotUniqueError

from travel.avia.avia_api.avia.v1.model.db import db

log = logging.getLogger(__name__)


class DistributedLock(db.Document):
    name = db.StringField(unique=True, required=True)
    expire_after = db.DateTimeField(default=datetime.utcnow, required=True)

    meta = {
        'indexes': [{
            'fields': ['expire_after'],
            'expireAfterSeconds': 0
        }]
    }


def single_process(name, expire_after, release=True):
    """
    Использует распределенный монголок для запуска задачи в 1 экземпляре
    :type name: basestring
    :type expire_after: datetime
    :param bool release: True - освобождает лок после выполнения задачи,
                         False - освобождает лок после expire_after
    :return:
    """

    def decorator(f):
        @wraps(f)
        def wrapper(*args, **kwargs):
            lock = DistributedLock(name=name, expire_after=expire_after)

            try:
                lock.save()
            except NotUniqueError:
                log.info('Other %s process is running', f.__name__)
                return

            try:
                return f(*args, **kwargs)
            finally:
                if release:
                    lock.delete()

        return wrapper

    return decorator
