from travel.avia.avia_api.avia.v1.model.db import db


class Passengers(db.EmbeddedDocument):
    adults = db.IntField(required=True)
    children = db.IntField(required=True)
    infants = db.IntField(required=True)

    def format_key(self):
        return '{0.adults}_{0.children}_{0.infants}'.format(self)

    @property
    def price_multiplier(self):
        return self.adults + self.children * 0.6 + self.infants * 0.1

    def __eq__(self, other):
        if not isinstance(other, Passengers):
            return False
        return (
            self.adults == other.adults and
            self.children == other.children and
            self.infants == other.infants
        )
