# -*- coding: utf-8 -*-
from datetime import datetime, timedelta

from travel.avia.avia_api.avia.v1.model.db import db


class VariantsYtHistory(db.Document):
    meta = {
        'strict': False,
    }
    computed_at = db.DateTimeField(required=True, null=False, default=datetime.utcnow)

    min_prices_variants_table = db.StringField(null=False, required=True)
    min_prices_qkey_table = db.StringField(null=False, required=True)
    popular_variants_table = db.StringField(null=False, required=True)

    @staticmethod
    def recent(hours=12):
        """
        :return: Latest VariantsYtHistory if it's not older than 12 hours
        :rtype: VariantsYtHistory
        """
        return VariantsYtHistory.objects.filter(
            computed_at__gt=datetime.utcnow() - timedelta(hours=hours)
        ).order_by('-computed_at').first()

    def __str__(self):
        return self.to_json()


class SubscriptionPreheatHistory(db.Document):
    meta = {
        'strict': False,
    }
    preheated_at = db.DateTimeField(required=True, null=False, default=datetime.utcnow)

    active_subscriptions_count = db.IntField(required=True, null=False)
    cold_subscriptions_count = db.IntField(required=True, null=False)
    preheated_subscriptions_count = db.IntField(required=True, null=False)
    td_limit_exceeded = db.BooleanField(required=True, null=False)

    @staticmethod
    def recent(hours=12):
        """
        :return: Latest VariantsYtHistory if it's not older than 12 hours
        :rtype: VariantsYtHistory
        """
        return SubscriptionPreheatHistory.objects.filter(
            preheated_at__gt=datetime.utcnow() - timedelta(hours=hours)
        ).order_by('-preheated_at').first()

    def __str__(self):
        return self.to_json()
