# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from marshmallow.exceptions import ValidationError
from marshmallow.fields import *
from marshmallow import fields as marsh_fields


class DateYMD(marsh_fields.Date):
    def _serialize(self, value, attr, obj):
        if value is None:
            return None

        try:
            return value.strftime('%Y-%m-%d')

        except AttributeError:
            msg = '{0} cannot be formatted as a date.'.format(repr(value))
            raise ValidationError(getattr(self, 'error', None) or msg)


class DateTimeBlank(marsh_fields.DateTime):
    def _deserialize(self, value, attr, data):
        if value is None or not value:
            return None

        return super(DateTimeBlank, self)._deserialize(value, attr, data)
