from marshmallow import fields

from travel.avia.avia_api.avia.api.daemon_api import HttpChance
from travel.avia.avia_api.avia.v1.schemas import (
    ApiSchema, TariffSchema, CompanySchema, HttpTripSchema,
)


class RedirectDataSchema(ApiSchema):
    url = fields.String(default=None)
    post = fields.Dict()


class HttpOrderVariantSchema(ApiSchema):
    partner = fields.Function(lambda v: v.partner.code)
    sort_order = fields.Integer()
    tariff = fields.Nested(TariffSchema)
    original_tariff = fields.Nested(TariffSchema)
    forward = fields.String(attribute='forward.key')
    backward = fields.String(attribute='backward.key')
    chance = fields.Method('_chance')
    created = fields.Constant('2016-01-01 00:00:00 +0000')  # backward compatibility, maybe it's useless
    expire = fields.DateTime(attribute='expire_dt', format='%Y-%m-%d %H:%M:%S %z')
    charter = fields.Function(lambda v: v.is_charter or None)
    from_company = fields.Function(lambda v: v.partner.is_aviacompany or None)

    def _chance(self, variant):
        return HttpChance.from_variant(
            variant,
            self.context['national_version'],
            self.context['lang'],
            self.context['qid'],
        ).encrypt()


class HttpOrderViewSchema(ApiSchema):
    trips = fields.List(fields.Nested(HttpTripSchema))
    variants = fields.List(fields.Nested(HttpOrderVariantSchema))
    companies = fields.Nested(CompanySchema, many=True)
