from django.conf import settings
from flask import Blueprint

import travel.avia.avia_api.ant.api_interface
from travel.avia.avia_api.avia.lib.flask_authdigest import FlaskRealmDigestDB


sovetnik_blueprint = Blueprint('sovetnik_v1', __name__)

sovetnik_auth_db = FlaskRealmDigestDB(
    realm='SovetnikApi',
    users=[
        (
            settings.SOVETNIK_API_USERNAME,
            settings.SOVETNIK_API_PASSWORD
        ),
    ]
)

sovetnik_api = travel.avia.avia_api.ant.api_interface.Ant(
    sovetnik_blueprint,
    auth_decorator=sovetnik_auth_db.requires_auth,
)
