from django.conf import settings
from django.utils.functional import cached_property

from travel.avia.library.python.common.cache.substitutions import substitution_cache
from travel.avia.library.python.common.geotargeting.lookup import get_city_by_ip
from travel.avia.library.python.common.models.currency import Currency
from travel.avia.library.python.common.models.geo import Settlement, Country

from travel.avia.avia_api.avia.api.daemon_api import PointReference


class UserInfo(object):
    def __init__(self, geo_id=None, ip=None):
        if geo_id:
            self._geo_id = geo_id
        elif ip:
            _, self._geo_id = get_city_by_ip(ip)
        else:
            self._geo_id = None

    def currency(self):
        return (
            self._country.currency or
            Currency.objects.get(
                code=settings.AVIA_NATIONAL_CURRENCIES[self.national_version()]
            )
        )

    def national_version(self):
        return {
            'RU': 'ru',
            'UA': 'ua',
            'TR': 'tr',
            'KZ': 'kz',
            'BY': 'ru',
        }.get(self._country.code, 'com')

    def country(self):
        return self._country

    @cached_property
    def settlement(self):
        if self._geo_id:
            try:
                return Settlement.objects.get(_geo_id=self._geo_id)
            except Settlement.DoesNotExist:
                pass

    @cached_property
    def _country(self):
        if self.settlement:
            return self.settlement.country
        return Country.objects.get(code='RU')


class SovetnikPointReference(PointReference):
    def __init__(self, point, is_substitution):
        super(SovetnikPointReference, self).__init__(point)
        self.substitution = is_substitution


def substitution_reference(point):
    substitution_point = (
        substitution_cache.avia_settlement(settlement=point) or point
        if isinstance(point, Settlement)
        else point
    )
    return SovetnikPointReference(
        substitution_point,
        is_substitution=(substitution_point != point),
    )
