# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from flask import abort, Blueprint
from flask_login import LoginManager

import travel.avia.avia_api.ant.api_interface
from travel.avia.avia_api.avia.lib.app_user import AppUser

log = logging.getLogger(__name__)

bp_api_v1 = Blueprint('api_1_0', __name__)
bp_api_v2 = Blueprint('api_2_0', __name__)

login_manager = LoginManager()


@bp_api_v1.record_once
def on_load(state):
    login_manager.init_app(state.app)


login_manager.user_loader(AppUser.load)


@login_manager.unauthorized_handler
def unauthorized():
    """
    RASPTICKETS-9613 - для мобильных юзеров 403, а не 401 код - знак того, что
    нужно обновить сессию.
    """
    abort(403)


def dict_slice(d, keys):
    return {key: d[key] for key in keys if key in d}


api = travel.avia.avia_api.ant.api_interface.Ant(bp_api_v1)

api_v2 = travel.avia.avia_api.ant.api_interface.Ant(bp_api_v2)
