# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from flask_login import current_user, login_required

from travel.avia.avia_api.avia.lib.currency import CurrencyRatesInfoStorage
from travel.avia.avia_api.avia.v1.views.base import api


@api.view('/currency_rates/')
@login_required
@api.process_viewparams
def currency_rates():
    rates_info = CurrencyRatesInfoStorage().info(current_user.national_version)

    return {
        'src': rates_info.source(),
        'rates': rates_info.rates(),
    }
