# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from flask_login import current_user, login_required

from travel.avia.avia_api.ant.api_interface import ViewParam
from travel.avia.avia_api.ant.custom_types import ArgLang
from travel.avia.avia_api.avia.v1.model.flight import Flight
from travel.avia.avia_api.avia.v1.model.user import User
from travel.avia.avia_api.avia.v1.schemas import (
    FlightListViewSchema
)
from travel.avia.avia_api.avia.v1.views.base import api

log = logging.getLogger(__name__)


@api.view('/flight/list/', sort_order=19.1)
@login_required
@api.result_schema(FlightListViewSchema)
def flight_list(
    lang=ViewParam(type_=ArgLang(), required=False),
    key=ViewParam(required=False),
    schema_context=None
):
    """ Получить вылеты """

    user = User.get_by_appuser(current_user)

    schema_context['lang'] = lang or current_user.lang

    flights = [
        f for f in user.flights
        if not key or f.key == key
    ]

    for f in flights:
        if f in user.aeroex_notify_flights:
            f.user_aeroexpress = f.aeroexpress

    return {
        'flights': sorted(flights, key=lambda f: f.departure_datetime)
    }


@api.view('/flight/drop/', sort_order=19.2)
@login_required
@api.process_viewparams
def flight_drop(
    key=ViewParam()
):
    """ Удалить вылет """

    user = User.get_by_appuser(current_user)

    user.update(pull__aeroex_notify_flights=Flight(id=key))
    user.update(pull__flights=Flight(id=key))

    return 'ok'
