# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from flask import make_response
from flask_login import current_user, login_required

from travel.avia.avia_api.ant.api_interface import ViewParam
from travel.avia.avia_api.avia.v1.views.base import api

log = logging.getLogger(__name__)


@api.view('/push_geo_settings/')
@login_required
@api.process_viewparams
def push_geo_settings(sim_countries=ViewParam(required=False),
                      location_services_country=ViewParam(required=False),
                      settings_country=ViewParam(required=False),
                      settings_lang=ViewParam(required=False),
                      locale=ViewParam(required=False)):

    log.info(
        'Appuser=%r, sim_countries=%s, location_services_country=%s, '
        'settings_country=%s, settings_lang=%s, locale=%s',
        current_user, sim_countries, location_services_country,
        settings_country, settings_lang, locale
    )

    return make_response('', 200)
