# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging

from django.conf import settings
from flask_login import current_user, login_required

from travel.avia.library.python.common.geotargeting.lookup import get_city_by_ip

import travel.avia.avia_api.ant.custom_types
from travel.avia.avia_api.ant.api_interface import ViewParam
from travel.avia.avia_api.ant.custom_types import (
    ArgPoint, ArgFlightClass, HttpSearchIdentificator
)
from travel.avia.avia_api.avia.daemon_http_api import TicketDaemon, LoggingTD
from travel.avia.avia_api.avia.lib.flight_classes import FlightClass
from travel.avia.avia_api.avia.v1.views.base import api

log = logging.getLogger(__name__)


@api.view('/search/')
@login_required
@api.process_viewparams
def http_search(
    point_from=ViewParam(name='from', type_=ArgPoint(), about='Пункт вылета'),
    point_to=ViewParam(name='to', type_=ArgPoint(), about='Пункт прибытия'),
    date_forward=ViewParam(
        name='when', type_=travel.avia.avia_api.ant.custom_types.Date(), about='Дата вылета'
    ),
    date_backward=ViewParam(
        name='return_date', type_=travel.avia.avia_api.ant.custom_types.Date(), about='Дата вылета обратно',
        required=False
    ),
    adults=ViewParam(
        name='adult', type_=travel.avia.avia_api.ant.custom_types.Int([1, 9]), default=1,
        about='Количество взрослых'
    ),
    children=ViewParam(
        name='child', type_=travel.avia.avia_api.ant.custom_types.Int([0, 9]), default=0,
        about='Количество детей'
    ),
    infants=ViewParam(
        name='infant', type_=travel.avia.avia_api.ant.custom_types.Int([0, 9]), default=0,
        about='Количество младенцев'
    ),
    flight_class=ViewParam(
        name='class', type_=ArgFlightClass(), default=FlightClass.Economy,
    ),
):
    city, geo_id = get_city_by_ip(current_user.remote_addr)

    # RASPTICKETS-4957 - logs for agave
    log.info('Search request with app_key=%s', current_user.app_key)

    qid = LoggingTD(TicketDaemon(settings.DAEMON_URL)).init_search(
        point_from=point_from,
        point_to=point_to,
        date_forward=date_forward,
        date_backward=date_backward,
        adults=adults, children=children, infants=infants,
        flight_class=flight_class,
        national_version=current_user.national_version,
        lang=current_user.lang,
        country_geo_id=city.country._geo_id if city else None,
        service='api_avia',
        user_passportuid=current_user.yandex_uid,
        user_ip=current_user.remote_addr,
        user_platform=settings.BILLING_PLATFORMS.get(current_user.platform),
        user_uuid=current_user.uuid,
        user_geoid=geo_id,
    )
    return {
        'search_id': HttpSearchIdentificator(
            qid=qid,
            point_from_key=point_from.point_key,
            point_to_key=point_to.point_key,
            national_version=current_user.national_version,
            date_forward=date_forward,
        ).encrypt()
    }
