import os
import sys

if __name__ == '__main__':
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.avia_api.local_settings')

    import gevent.monkey

    gevent.monkey.patch_all()

    import django
    django.setup()

    from flask_script import Manager
    from django.conf import settings

    import travel.avia.avia_api.avia.v1.email_dispenser.commands as email_commands
    from travel.avia.avia_api.avia import commands
    from travel.avia.avia_api.avia.application import create_app

    app = create_app()  # configures mongodb for mongo migrations by the way

    from travel.avia.avia_api.bin.manage.migrations_manager import PendingMigrations

    class RPManager(Manager):
        def handle(self, prog, args=None):
            if args and args[0] == 'run_path':
                sys.argv = list(args[1:])
                import runpy
                runpy.run_path(sys.argv[0], run_name='__main__')
            else:
                super(RPManager, self).handle(prog, args)

    manager = RPManager(app)

    @manager.command
    def list_routes():
        import urllib
        from flask import url_for
        output = []
        for rule in app.url_map.iter_rules():

            options = {}
            for arg in rule.arguments:
                if arg != '_route_id':
                    options[arg] = '[{0}]'.format(arg)

            methods = ','.join(rule.methods)
            url = url_for(rule.endpoint, **options)
            raw_line = '{:50s} {:20s} {}'.format(rule.endpoint, methods, url)
            line = urllib.unquote(raw_line)
            output.append(line)

        for line in sorted(output):
            print line

    @manager.command
    def test_favorites_bug():
        from travel.avia.avia_api.avia.v1.model.user import User
        print 'Users: %s', len(User.objects)

    @manager.option('-l', '--lang', required=False)
    def update_por(lang=None):
        langs = [lang] if lang is not None else settings.AVIA_API_LANGUAGES
        commands.cache_por_for_languages(langs)

    @manager.option('-m', '--migration_filename', required=False)
    def execute_migration(migration_filename=None):
        PendingMigrations().execute(migration_filename)
        exit(0)  # MAPADMIN-22183 etc

    @manager.option('-m', '--migration_filename')
    def rollback_migration(migration_filename):
        PendingMigrations().rollback(migration_filename)
        exit(0)  # MAPADMIN-22183 etc

    manager.command(commands.push_aeroexpress_notifications)
    manager.command(commands.update_min_prices)
    manager.command(email_commands.send_emails)
    manager.command(email_commands.send_email_to)
    manager.command(email_commands.update_subscriptions)
    manager.command(email_commands.set_test_min_price_for_direction)
    manager.command(email_commands.set_test_min_price_for_direction_no_variants)
    manager.command(email_commands.set_test_min_price_for_filtered_direction)
    manager.command(email_commands.set_test_min_price_for_filtered_direction_no_variants)
    manager.command(email_commands.preheat_subscriptions)
    manager.command(email_commands.cleanup_bad_subscriptions)

    manager.run()
