import os

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'travel.avia.avia_api.local_settings')

proc_name = 'avia-api'
bind = os.getenv('AVIA_BIND_ADDRESS', 'unix:/var/run/yandex-avia-api.sock')
workers = int(os.getenv('AVIA_GUNICORN_WORKERS', 4))

worker_class = 'gevent'
worker_connections = 1000

max_requests = 10000

loglevel = os.getenv('AVIA_LOG_LEVEL', 'INFO')
errorlog = os.getenv('AVIA_GUNICORN_LOG', '/ephemeral/var/log/yandex-avia-api/gunicorn.log')
capture_output = True

preload_app = True
# noinspection PyUnresolvedReferences
from travel.avia.avia_api.avia.api.caches import shared_cache  # noqa: F401
from travel.avia.avia_api.local_settings import PING_SLEEP_TIME, CACHE_REDIS  # noqa: F401
from travel.avia.library.python.common.precache.gunicorn.conf import precache  # noqa: F401
from travel.avia.library.python.redis.ping import RedisPing  # noqa: F401


key_ttl = 60
ping = RedisPing(shared_cache, key_ttl, PING_SLEEP_TIME)


def on_starting(server):
    precache(server)
    if CACHE_REDIS:
        ping.run()


def on_reload(server):
    precache(server)
    if CACHE_REDIS:
        ping.run()


def on_exit(server):
    if CACHE_REDIS:
        ping.stop()


def pre_fork(server, worker):
    from django.core.cache import cache
    cache.close()
