# -*- coding: utf-8 -*-
from travel.avia.library.python.common import qloud
from travel.avia.library.python.redis.settings import RedisConfigurator

from travel.avia.avia_api.avia.settings import *

CURRENT_DC = qloud.get_current_dc()

YANDEX_ENVIRONMENT_TYPE = os.getenv('YANDEX_ENVIRONMENT_TYPE', 'development')

MDB_API_TOKEN = os.getenv('AVIA_YC_OAUTH_TOKEN')
MYSQL_CLUSTER_ID = os.getenv('AVIA_MYSQL_CLUSTER_ID')

CACHE_REDIS = bool(env_variable_provider.get('CACHE_REDIS', required=False) == 'true')
SHARED_CACHE_REDIS = bool(env_variable_provider.get('SHARED_CACHE_REDIS', required=False) == 'true')
PING_SLEEP_TIME = int(env_variable_provider.get('PING_SLEEP_TIME', required=False, default=1000))
MAXIMUM_LAG = int(env_variable_provider.get('MAXIMUM_REDIS_REPLICA_LAG', required=False, default=1200))

CACHEROOT = '/yandex/avia-api/%s/' % PKG_VERSION


class PatchedEnvironmentSettings(EnvironmentSettings):
    registered_configs = {}  # кэши для демона стало труднее получить из кондуктора по-старому

    @classmethod
    def get_base_domain(cls):
        return ''


PatchedEnvironmentSettings.apply(globals())


def mcr_caches(hosts):
    if not hosts:
        raise ValueError('cannot configure mcrouter cache without hosts')

    return {
        'default': {
            'LOCATION': hosts,
            'TIMEOUT': 60,
            'LONG_TIMEOUT': 24 * 60 * 60,
            'OPTIONS': {'server_max_value_length': 128 * 1024 * 1024},
            'BACKEND': 'travel.avia.avia_api.avia.api.caches.LoggingMemcachedCache'
        }
    }


MCR_DAEMON_CACHES = mcr_caches(env_variable_provider.get('MCR_HOST', required=False, default='localhost:11211'))


def default_cache():
    if CACHE_REDIS:
        return RedisConfigurator(
            service_name=env_variable_provider.get('REDIS_SENTINEL_SERVICE_NAME'),
            redis_cluster_id=env_variable_provider.get('REDIS_CLUSTER_ID'),
            redis_password=env_variable_provider.get('REDIS_PASSWORD'),
            redis_port=int(env_variable_provider.get('REDIS_PORT', required=False, default=26379)),
            socket_timeout=float(env_variable_provider.get('REDIS_SOCKET_TIMEOUT', required=False, default=0.1)),
            oauth_token=MDB_API_TOKEN
        ).configure_redis()
    else:
        return MCR_DAEMON_CACHES


def shared_cache():
    if SHARED_CACHE_REDIS:
        return RedisConfigurator(
            service_name=env_variable_provider.get('SHARED_REDIS_SENTINEL_SERVICE_NAME'),
            redis_cluster_id=env_variable_provider.get('SHARED_REDIS_CLUSTER_ID'),
            redis_password=env_variable_provider.get('SHARED_REDIS_PASSWORD'),
            redis_port=int(env_variable_provider.get('SHARED_REDIS_PORT', required=False, default=26379)),
            socket_timeout=float(env_variable_provider.get(
                'SHARED_REDIS_SOCKET_TIMEOUT', required=False, default=0.1
            )),
            oauth_token=MDB_API_TOKEN
        ).configure_redis_master_only()
    else:
        return MCR_DAEMON_CACHES


DEFAULT_CACHE = default_cache()
SHARED_CACHE = shared_cache()

CACHES = {
    'default': DEFAULT_CACHE['default'],
    'shared_cache': SHARED_CACHE['default'],
    'replica_set': {
        'BACKEND': 'django.core.cache.backends.locmem.LocMemCache',
        'timeout': 60
    }
}

POR_CACHE_FILENAME = {
    lang: '/var/lib/yandex-avia-api/data/cache/por_%s' % lang
    for lang in AVIA_API_LANGUAGES
}

DAEMON_URL = env_variable_provider.get('DAEMON_URL', required=False)
SHARED_FLIGHTS_API_URL = env_variable_provider.get('SHARED_FLIGHTS_API_URL', required=False)
SENTRY_DSN = env_variable_provider.get('SENTRY_DSN', required=False)

MONGO_USER = env_variable_provider.get('MONGO_USER', required=False)
MONGO_DB = env_variable_provider.get('MONGO_DB', required=False)
MONGO_PWD = env_variable_provider.get('MONGO_DBAAS_PASSWORD', required=False)
MONGO_HOSTS = env_variable_provider.get('MONGO_HOSTS', required=False)

BLACKBOX_URL = env_variable_provider.get('BLACKBOX_URL', required=False)

# Todo: could be parsed from ENV variable QLOUD_TVM_CONFIG
# format: {"BbEnvType":0,"clients":{"avia-api":{"secret":"***SECRET***","self_tvm_id":2001790,"dsts":{"blackbox":{"dst_id":222}}}}}
TVM_NAME = 'avia-api'
TVM_TAKEOUT_ID = env_variable_provider.get('TVM_TAKEOUT_ID', required=False)
if TVM_TAKEOUT_ID:
    TVM_TAKEOUT_ID = int(TVM_TAKEOUT_ID)
if YANDEX_ENVIRONMENT_TYPE != 'development':
    assert TVM_TAKEOUT_ID in [2009783, 2009785], 'Wrong TVM_TAKEOUT_ID'

ENABLE_TVM = env_variable_provider.get('ENABLE_TVM', required=False, default='false') == 'true'

if YANDEX_ENVIRONMENT_TYPE in {'testing', 'production'}:
    MONGODB_SETTINGS = {
        'host': 'mongodb://{user}:{pw}@{hosts}/{db}?replicaSet={rs}&authSource={db}'.format(
            user=MONGO_USER,
            pw=MONGO_PWD,
            hosts=MONGO_HOSTS,
            rs='rs01',
            db=MONGO_DB,
        ),
    }
else:
    MONGODB_SETTINGS = {
        'db': MONGO_DB,
        'host': '127.0.0.1',
    }

if YANDEX_ENVIRONMENT_TYPE == 'testing':
    FRONTEND_URLS = {
        'ru': 'https://front.avia.tst.yandex.ru',
        'ua': 'https://front.avia.tst.yandex.ua',
        'kz': 'https://front.avia.tst.yandex.kz',
        'tr': 'https://front.avia.tst.yandex.com.tr',
        'com': 'https://front.avia.tst.yandex.com',
    }

elif YANDEX_ENVIRONMENT_TYPE == 'production':
    XIVA_APP_NAME = {
        'default': 'ru.yandex.mobile.avia',
    }

elif YANDEX_ENVIRONMENT_TYPE == 'stress':
    FAKE_API_KEYS = True
    FAKE_CURRENCY_RATES = True
    FAKE_PUSHER = True

    FRONTEND_URLS = {
        'ru': 'https://front.avia.tst.yandex.ru',
        'ua': 'https://front.avia.tst.yandex.ua',
        'kz': 'https://front.avia.tst.yandex.kz',
        'tr': 'https://front.avia.tst.yandex.com.tr',
        'com': 'https://front.avia.tst.yandex.com',
    }

elif YANDEX_ENVIRONMENT_TYPE == 'development':
    DATABASES['default']['HOST'] = env_variable_provider.get('MYSQL_HOST', required=False, default='localhost')
    DATABASES['default']['NAME'] = env_variable_provider.get('MYSQL_DATABASE_NAME', required=False, default='avia')
    DATABASES['default']['USER'] = env_variable_provider.get('MYSQL_USER', required=False, default='root')
    DATABASES['default']['PASSWORD'] = env_variable_provider.get('MYSQL_PASSWORD', required=False, default='')

TRAVEL_URLS = FRONTEND_URLS.copy()
TRAVEL_URLS['ru'] = 'https://travel-test.yandex.ru/avia'
if YANDEX_ENVIRONMENT_TYPE == 'production':
    TRAVEL_URLS['ru'] = 'https://travel.yandex.ru/avia'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'root': {
        'level': 'INFO',
        'handlers': ['main_tree', 'sentry', 'error', 'traceback'],
    },
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s: %(message)s'
        },
        'simple': {
            'format': '%(message)s'
        },
        'error': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
        },
        'traceback': {
            '()': 'ylog.ExceptionFormatter',
            'format': '%(levelname)s %(asctime)s %(process)d %(pathname)s:%(funcName)s:%(lineno)d %(message)s',
            'full': True,
            'show_locals': True
        },
    },
    'handlers': {
        'sentry': {
            'class': 'raven.contrib.django.raven_compat.handlers.SentryHandler',
            'level': 'ERROR',
        },
        'sentry_error': {
            'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'main', 'sentry_error.log'),
            'formatter': 'error',
            'level': 'ERROR',
        },
        'error': {
            'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'main', 'error.log'),
            'formatter': 'error',
            'level': 'ERROR',
        },
        'traceback': {
            'class': 'travel.avia.library.python.common.utils.logs.WatchedFileHandler',
            'filename': os.path.join(LOG_PATH, 'main', 'traceback.log'),
            'formatter': 'traceback',
            'level': 'ERROR',
        },
        'main_tree': {
            'level': 'DEBUG',
            'class': 'travel.avia.library.python.common.utils.logs.FileTreeHandler',
            'base_path': os.path.join(LOG_PATH, 'main'),
            'formatter': 'verbose',
        },
        'tree': {
            'level': 'DEBUG',
            'class': 'travel.avia.library.python.common.utils.logs.FileTreeHandler',
            'base_path': LOG_PATH,
            'formatter': 'verbose',
        },
        'tree_simple': {
            'level': 'INFO',
            'class': 'travel.avia.library.python.common.utils.logs.FileTreeHandler',
            'base_path': LOG_PATH,
            'formatter': 'simple',
        },
    },
    'loggers': {
        'error': {
            'handlers': ['error'],
            'level': 'ERROR',
        },
        'traceback': {
            'handlers': ['traceback'],
            'level': 'ERROR',
        },
        'hello': {
            'handlers': ['tree'],
            'level': 'INFO',
            'propagate': False,
        },
        'yt': {
            'handlers': ['tree_simple'],
            'level': 'INFO',
            'propagate': False,
        },
        'sentry.errors': {  # is used in raven.base.Client
            'handlers': ['sentry_error'],
            'level': 'ERROR',
            'propagate': False,
        }
    }
}

PARTNERS_BOOKING_AVAILABLE_HOURS = {'ozon': 12, 'pilotua': 4.5}

from library.python.django.utils import patch_settings_for_arcadia  # noqa
patch_settings_for_arcadia()
