# -*- coding: utf-8 -*-
import json
import sqlite3
import sys


with open(sys.argv[1], 'rb') as f:
    por = json.load(f)

conn = sqlite3.connect(sys.argv[2])


def paste(table, items, mapping):
    json_keys, sqlite_keys = zip(*(mapping.items()))
    query = 'INSERT INTO %s(%s) VALUES (%s)' % (
        table,
        ','.join(sqlite_keys),
        ','.join(['?' for j in sqlite_keys])
    )
    datarows = [[item.get(key) for key in json_keys] for item in items]
    conn.executemany(query, datarows)


conn.execute('DELETE FROM zcountry')
paste('zcountry', por['data']['countries'], {
    'key': 'ZID',
    'geoid': 'ZGEOID',
    'iso_code': 'ZISOCODE',
    'title': 'ZTITLE',
})

conn.execute('DELETE FROM zcity')
paste('zcity', por['data']['cities'], {
    'key': 'ZID',
    'title': 'ZTITLE',
    'geoid': 'ZGEOID',
    'iata': 'ZIATA',
    'country_key': 'ZCOUNTRYID',
    'is_capital': 'ZISCAPITAL',
})

conn.execute('DELETE FROM zairport')
paste('zairport', por['data']['airports'], {
    'has_aeroexpress': 'ZHASAEROEXPRESS',
    'city_key': 'ZCITYID',
    'iata': 'ZIATA',
    'key': 'ZID',
    'sirena': 'ZSIRENA',
    'title': 'ZTITLE',
})

conn.commit()
conn.close()
