#!/usr/bin/env bash

logfile="/ephemeral/var/log/yandex-avia-api/main/avia/lib/pusher.log"

function analyze {
    python -c "
import sys
import re
from collections import defaultdict

regex = re.compile(
    r'\S+ \S+ \S+ Push stats: transport:(\w+), tag:(\w+), uuids:(\d+), pushes_sent:(\d+)'
)

tags = defaultdict(
    lambda: defaultdict(
        lambda: defaultdict(int)
    )
)

for line in sys.stdin:
    match = regex.match(line)
    if match is not None:
        transport, tag, uuids, sent = match.groups()
        tags[transport][tag]['uuids'] += int(uuids)
        tags[transport][tag]['sent'] += int(sent)

for transport, data in tags.iteritems():
    for tag, values in tags[transport].iteritems():
        print transport.lower(), tag, values['uuids'], values['sent']
"
}

function send {
    read metric count <<< $(echo "$@")

    local prefix=geo.rasp
    local service=rasp_avia_api
    local host=${QLOUD_HOSTNAME//[.]/_}
    local type=push_statistics

    echo $prefix.$service.$host.$type.$metric $count `date +%s` | nc localhost 42000
}

# last 10 minutes
timetail -j 99999 -t java -n 600 ${logfile} | analyze | while read line; do
    read transport tag uuids sent <<< $(echo "$line")

    send "${transport}_${tag}_pushes_sent_to_uuids" "${uuids}"
    send "${transport}_${tag}_pushes_sent_successfully" "${sent}"
done
