#!/usr/bin/env bash

hello_log="/ephemeral/var/log/yandex-avia-api/main/avia/v1/views/auth.log"
hello_tempfile="/tmp/hello_app_key_log"

search_log="/ephemeral/var/log/yandex-avia-api/main/avia/v1/views/search.log"
search_tempfile="/tmp/search_app_key_log"


function analyze {
    python -c "
import sys
import re
from collections import defaultdict

regex = re.compile(
    r'request.+app_key=([0-9a-f\-]{36})'
)

counter = defaultdict(int)

for line in sys.stdin:
    match = regex.search(line)
    if match is not None:
        [app_key] = match.groups()
        counter[app_key] += 1

for app_key, count in counter.iteritems():
    app_key = app_key.replace('-', '')
    print app_key, count
"
}


function send {
    read metric count <<< $(echo "$@")

    local prefix=geo.rasp
    local service=rasp_avia_api
    local host=${QLOUD_HOSTNAME//[.]/_}
    local type=requests_by_keys

    echo $prefix.$service.$host.$type.$metric count `date +%s` | nc localhost 42000
}

# last 10 minutes

timetail -j 99999 -t java -n 600 ${hello_log} | analyze | while read line; do
    read app_key count <<< $(echo "$line")
    send "${app_key}_hello_requests" "${count}"
done

timetail -j 99999 -t java -n 600 ${search_log} | analyze | while read line; do
    read app_key count <<< $(echo "$line")
    send "${app_key}_search_requests" "${count}"
done
