PY2_LIBRARY()

OWNER(g:avia)

PEERDIR(
    contrib/python/cachetools
    contrib/python/Flask-Login
    contrib/python/Pillow
    contrib/python/django/django-1.11
    contrib/python/flask-cors
    travel/avia/contrib/python/flask_mongoengine
    contrib/python/geoindex
    contrib/python/gevent
    contrib/python/gunicorn
    contrib/python/marshmallow/py2
    contrib/python/MySQL-python
    contrib/python/pycountry
    contrib/python/PyMySQL
    contrib/python/raven
    contrib/python/ujson

    yt/python/client
    yt/yt/python/yt_yson_bindings

    travel/library/python/tvm_ticket_provider

    travel/avia/library/python/avia_data
    travel/avia/library/python/common
    travel/avia/library/python/django_namedtuples
    travel/avia/library/python/environment_helpers
    travel/avia/library/python/feature_flag_client
    travel/avia/library/python/http_geobase
    travel/avia/library/python/redis
    travel/avia/library/python/route_search
    travel/avia/library/python/shared_flights_client

    travel/rasp/library/python/hemi
)

PY_SRCS(
    ant/api_interface.py
    ant/argparser.py
    ant/argument.py
    ant/custom_types.py
    ant/exceptions.py
    ant/iso_types.py
    avia/__init__.py
    avia/api/caches.py
    avia/api/daemon_api.py
    avia/api/flights.py
    avia/api/model_utils/__init__.py
    avia/api/model_utils/partner.py
    avia/api/models/__init__.py
    avia/api/query.py
    avia/api/redirect.py
    avia/api/reference.py
    avia/application/__init__.py
    avia/application/base.py
    avia/business/hello.py
    avia/cache/companies.py
    avia/cache/dynamics.py
    avia/cache/partners.py
    avia/cache/settlements.py
    avia/cache/stations.py
    avia/cache/top_flights.py
    avia/cache/utils.py
    avia/commands.py
    avia/daemon_http_api.py
    avia/health.py
    avia/http_api_schemas.py
    avia/lib/api_json.py
    avia/lib/apikeys.py
    avia/lib/app_user.py
    avia/lib/authdigest.py
    avia/lib/cache.py
    avia/lib/currency.py
    avia/lib/date.py
    avia/lib/decorators.py
    avia/lib/descriptor.py
    avia/lib/feature_flag.py
    avia/lib/flask_authdigest.py
    avia/lib/flight_classes.py
    avia/lib/flight_info.py
    avia/lib/geo.py
    avia/lib/helpers.py
    avia/lib/jsend.py
    avia/lib/min_price_storage.py
    avia/lib/money_logs.py
    avia/lib/mongo_iterator.py
    avia/lib/passport_utils.py
    avia/lib/push_notifications.py
    avia/lib/pusher/__init__.py
    avia/lib/pusher/exception.py
    avia/lib/pusher/tag.py
    avia/lib/pusher/transport/__init__.py
    avia/lib/pusher/transport/xiva.py
    avia/lib/remote_addr.py
    avia/lib/search_utils.py
    avia/lib/serialization.py
    avia/lib/sessions.py
    avia/lib/shared_flights.py
    avia/lib/storage.py
    avia/lib/timer.py
    avia/lib/user_flights.py
    avia/lib/variants.py
    avia/lib/variants_reference.py
    avia/lib/yt_loggers/email_subscriptions/email_logs.py
    avia/lib/yt_loggers/email_subscriptions/user_logs.py
    avia/lib/yt_loggers/yt_log.py
    avia/middleware/base.py
    avia/middleware/django_request.py
    avia/middleware/environ_now.py
    avia/middleware/http_schema_proxy.py
    avia/middleware/yandex_auth.py
    avia/settings/__init__.py
    avia/settings/general.py
    avia/v1/afl_search/__init__.py
    avia/v1/afl_search/api.py
    avia/v1/afl_search/flights_network.py
    avia/v1/afl_search/schemas.py
    avia/v1/email_dispenser/api.py
    avia/v1/email_dispenser/commands/__init__.py
    avia/v1/email_dispenser/commands/decorators.py
    avia/v1/email_dispenser/commands/preheat_subscriptions_td.py
    avia/v1/email_dispenser/commands/send_price_changes_emails.py
    avia/v1/email_dispenser/commands/set_test_min_prices.py
    avia/v1/email_dispenser/commands/subscriptions_maintenance.py
    avia/v1/email_dispenser/commands/update_subscriptions_info.py
    avia/v1/email_dispenser/helpers/build_email.py
    avia/v1/email_dispenser/helpers/currency.py
    avia/v1/email_dispenser/helpers/mysql_cache.py
    avia/v1/email_dispenser/helpers/qkey_utils.py
    avia/v1/email_dispenser/helpers/variants_combiner.py
    avia/v1/email_dispenser/helpers/variants_filter.py
    avia/v1/email_dispenser/helpers/yt_cache.py
    avia/v1/email_dispenser/sender.py
    avia/v1/email_dispenser/settings.py
    avia/v1/email_dispenser/variants_fetcher/preheat_subscriptions_yt.py
    avia/v1/email_dispenser/variants_fetcher/runme.py
    avia/v1/email_dispenser/variants_fetcher/variants_log_yt.py
    avia/v1/internal/__init__.py
    avia/v1/internal/api.py
    avia/v1/internal/flights.py
    avia/v1/internal/info.py
    avia/v1/internal/inspect.py
    avia/v1/model/aeroexpress.py
    avia/v1/model/constants.py
    avia/v1/model/db.py
    avia/v1/model/device.py
    avia/v1/model/distributed_lock.py
    avia/v1/model/favorite.py
    avia/v1/model/filters.py
    avia/v1/model/flight.py
    avia/v1/model/flight_status.py
    avia/v1/model/passengers.py
    avia/v1/model/subscriber.py
    avia/v1/model/user.py
    avia/v1/model/variants_compute_history.py
    avia/v1/model_django.py
    avia/v1/schemas/__init__.py
    avia/v1/schemas/fields.py
    avia/v1/schemas/min_prices.py
    avia/v1/schemas/order.py
    avia/v1/schemas/schemas.py
    avia/v1/sovetnik/__init__.py
    avia/v1/sovetnik/api.py
    avia/v1/sovetnik/dynamics.py
    avia/v1/sovetnik/helpers.py
    avia/v1/sovetnik/http_search_results.py
    avia/v1/sovetnik/schemas.py
    avia/v1/sovetnik/search.py
    avia/v1/sovetnik/search_results.py
    avia/v1/takeout/api.py
    avia/v1/views/__init__.py
    avia/v1/views/auth.py
    avia/v1/views/base.py
    avia/v1/views/currency.py
    avia/v1/views/favorites.py
    avia/v1/views/flight.py
    avia/v1/views/flight_add.py
    avia/v1/views/info.py
    avia/v1/views/order.py
    avia/v1/views/push_geo_settings.py
    avia/v1/views/search.py
    avia/v1/views/search_results.py
    avia/version.py
    gunicorn_conf.py
    local_settings.py
    wsgi.py
)

RESOURCE_FILES(
    PREFIX travel/avia/avia_api/
    avia/keyset.json
)

END()

RECURSE_FOR_TESTS(
    tests
)

RECURSE(
    bin
)
