package app

import (
	"time"

	"a.yandex-team.ru/travel/avia/avia_statistics/api/internal/pkg/dicts"
	"a.yandex-team.ru/travel/avia/avia_statistics/api/internal/pkg/ydb"
	"a.yandex-team.ru/travel/avia/library/go/probes"
	dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"
	httpserver "a.yandex-team.ru/travel/library/go/httputil/server"
	"a.yandex-team.ru/travel/library/go/logging"
	metricsserver "a.yandex-team.ru/travel/library/go/metrics/server"
)

type TvmConfig struct {
	Enabled       bool          `config:"TVM_ENABLED"`
	WhiteList     []uint32      `config:"TVM_WHITE_LIST"`
	CacheTTL      time.Duration `config:"TVM_CACHE_TTL" yaml:"cache-ttl"`
	CacheMaxItems int           `config:"TVM_CACHE_MAX_ITEMS" yaml:"cache-max-items"`
}

type Config struct {
	EnvType          string `config:"yenv-type,required" yaml:"env_type"`
	Dicts            dicts.Config
	DynamicResources dynamicdicts.Config
	HTTP             httpserver.HTTPConfig
	Metrics          metricsserver.MetricsConfig
	Logging          logging.Config
	Tvm              TvmConfig
	Ydb              ydb.Config
	Probes           probes.HTTPConfig `yaml:"probes"`
}

var DefaultTvmConfig = TvmConfig{
	CacheTTL:      3 * time.Minute,
	CacheMaxItems: 128,
}

var Cfg = Config{
	EnvType:          "development",
	Dicts:            dicts.DefaultConfig,
	DynamicResources: dynamicdicts.DefaultConfig,
	HTTP:             httpserver.DefaultHTTPConfig,
	Metrics:          metricsserver.DefaultMetricsConfig,
	Logging:          logging.DefaultConfig,
	Tvm:              DefaultTvmConfig,
	Ydb:              ydb.DefaultConfig,
	Probes:           probes.DefaultHTTPConfig,
}
