package handler

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/avia/avia_statistics/api/internal/landingcityto"
)

type LandingBuilder interface {
	Build(context.Context, *landingcityto.CityToQuery) (*landingcityto.CityToLanding, error)
}

const metricsPrefix = "landing_city_to"

var timingBuckets = metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.4, 20)
