package landingcityto

import (
	"errors"
)

var ErrorNotFound = errors.New("NotFound")

type CityToQuery struct {
	ToID            uint32
	NationalVersion string
	Fields          []string
}

func NewCityToQuery(toID uint32, nationalVersion string, fields []string) *CityToQuery {
	return &CityToQuery{ToID: toID, NationalVersion: nationalVersion, Fields: fields}
}

type CityToLanding struct {
	ToID                     uint32                       `json:"toId"`
	CityToRouteCrosslinks    []CityToRouteCrosslink       `json:"routeCrosslinks"`
	CityToMonthAndYearPrices CityToMonthAndYearPriceInfo  `json:"monthAndYearPrices"`
	CityToNearestCities      []CityToNearestCityWithPrice `json:"nearestCities"`
}

type CityTo struct {
	ToID            uint32 `json:"to_id"`
	NationalVersion string `json:"national_version"`
}

type CityToRouteCrosslink struct {
	ToID            uint32  `json:"-"`
	NationalVersion string  `json:"-"`
	CrosslinkFromID uint32  `json:"crosslinkFromId"`
	CrosslinkToID   uint32  `json:"crosslinkToId"`
	Price           *uint32 `json:"price"`
	Currency        *string `json:"currency"`
	Date            *string `json:"date"`
}

type CityToMonthAndYearPriceInfo struct {
	ToID                    uint32 `json:"-"`
	NationalVersion         string `json:"-"`
	Currency                string `json:"currency"`
	YearMedianPrice         uint32 `json:"yearMedianPrice"`
	PopularMonthYear        uint32 `json:"popularMonthYear"`
	PopularMonth            uint8  `json:"popularMonth"`
	PopularMonthMedianPrice uint32 `json:"popularMonthMedianPrice"`
	MinMonthYear            uint32 `json:"minMonthYear"`
	MinMonth                uint8  `json:"minMonth"`
	MinMonthMedianPrice     uint32 `json:"minMonthMedianPrice"`
	MaxMonthYear            uint32 `json:"maxMonthYear"`
	MaxMonth                uint8  `json:"maxMonth"`
	MaxMonthMedianPrice     uint32 `json:"maxMonthMedianPrice"`
}

// will be in cache
type CityToNearestCities struct {
	ToID            uint32
	NationalVersion string
	NearestCityIds  []uint32
}

// return to client
type CityToNearestCityWithPrice struct {
	ID       uint32  `json:"id"`
	Price    *uint32 `json:"price"`
	Currency *string `json:"currency"`
	Date     *string `json:"date"`
}
