package dicts

import (
	"a.yandex-team.ru/travel/library/go/dicts"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"
)

type CountryRepository struct {
	*base.Repository
	*extensions.CountryByID
}

func NewCountryRepository() *CountryRepository {
	repo := &CountryRepository{
		base.NewRepository("CountryRepository", dicts.NewCountry),
		extensions.NewCountryByID(),
	}
	repo.AddExtensions(
		repo.CountryByID,
	)
	return repo
}

func (r *CountryRepository) UpdateFromSource(populator dynamicdicts.Populator) error {
	newRepo := NewCountryRepository()
	if err := populator.Populate(newRepo); err != nil {
		return err
	}
	*r = *newRepo
	return nil
}
