package dicts

import dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"

type Config struct {
	ResourcesPath       string `config:"DICTS_RESOURCES_PATH" yaml:"resources_path"`
	UseDynamicResources bool   `yaml:"use_dynamic_resources"`
}

var DefaultConfig = Config{
	ResourcesPath:       "/app/data",
	UseDynamicResources: false,
}

type Registry struct {
	*SettlementRepository
	*StationCodesRepository
	*StationRepository
	*CountryRepository
}

func NewRegistry() *Registry {
	return &Registry{
		SettlementRepository:   NewSettlementRepository(),
		StationCodesRepository: NewStationCodesRepository(),
		StationRepository:      NewStationRepository(),
		CountryRepository:      NewCountryRepository(),
	}
}

func (r *Registry) GetUpdatablesByPaths() map[string]dynamicdicts.Updatable {
	return map[string]dynamicdicts.Updatable{
		"country.data":      r.CountryRepository,
		"settlement.data":   r.SettlementRepository,
		"station.data":      r.StationRepository,
		"station_code.data": r.StationCodesRepository,
	}
}
