package dicts

import (
	"a.yandex-team.ru/travel/library/go/dicts"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"
)

type SettlementRepository struct {
	*base.Repository
	*extensions.SettlementByID
	*extensions.SettlementsByCountryID
}

func NewSettlementRepository() *SettlementRepository {
	repo := &SettlementRepository{
		Repository:             base.NewRepository("SettlementRepository", dicts.NewSettlement),
		SettlementByID:         extensions.NewSettlementByID(),
		SettlementsByCountryID: extensions.NewSettlementsByCountryID(),
	}
	repo.AddExtensions(
		repo.SettlementByID,
		repo.SettlementsByCountryID,
	)
	return repo
}

func (r *SettlementRepository) UpdateFromSource(populator dynamicdicts.Populator) error {
	newRepo := NewSettlementRepository()
	if err := populator.Populate(newRepo); err != nil {
		return err
	}
	*r = *newRepo
	return nil
}
