package dicts

import (
	"a.yandex-team.ru/travel/library/go/dicts"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"
)

type StationRepository struct {
	*base.Repository
	*extensions.StationByID
	*extensions.StationBySettlement
}

func NewStationRepository() *StationRepository {
	repo := &StationRepository{
		Repository:          base.NewRepository("StationRepository", dicts.NewStation),
		StationByID:         extensions.NewStationByID(),
		StationBySettlement: extensions.NewStationBySettlement(),
	}
	repo.AddExtensions(
		repo.StationByID,
		repo.StationBySettlement,
	)
	return repo
}

func (r *StationRepository) UpdateFromSource(populator dynamicdicts.Populator) error {
	newRepo := NewStationRepository()
	if err := populator.Populate(newRepo); err != nil {
		return err
	}
	*r = *newRepo
	return nil
}
