package dicts

import (
	"a.yandex-team.ru/travel/library/go/dicts"
	"a.yandex-team.ru/travel/library/go/dicts/base"
	"a.yandex-team.ru/travel/library/go/dicts/extensions"
	dynamicdicts "a.yandex-team.ru/travel/library/go/dicts/updaterservice"
)

type StationCodesRepository struct {
	*base.Repository
	*extensions.StationCodesByStationID
}

func NewStationCodesRepository() *StationCodesRepository {
	repo := &StationCodesRepository{
		base.NewRepository("StationCodesRepository", dicts.NewStationCode),
		extensions.NewStationCodesByStationID(),
	}
	repo.AddExtensions(repo.StationCodesByStationID)
	return repo
}

func (r *StationCodesRepository) UpdateFromSource(populator dynamicdicts.Populator) error {
	newRepo := NewStationCodesRepository()
	if err := populator.Populate(newRepo); err != nil {
		return err
	}
	*r = *newRepo
	return nil
}
