package tables

import "a.yandex-team.ru/kikimr/public/sdk/go/ydb/table"

type Config struct {
	ReadTableBatchSize                uint64
	PopularMonthsTableName            string
	ReturnTicketPricesTableName       string
	TopAirlinesTableName              string
	AlternativeRoutesPricesTableName  string
	MedianPricesTableName             string
	RouteInfosTableName               string
	RoutesTableName                   string
	MinPricesByAirlineTableName       string
	RouteCrosslinksTableName          string
	CityToRouteCrosslinksTableName    string
	CityToMonthAndYearPricesTableName string
	CityToNearestCitiesTableName      string
	DirectionPopularityTableName      string
}

var DefaultConfig = Config{
	ReadTableBatchSize:                10000,
	PopularMonthsTableName:            "popular_months",
	ReturnTicketPricesTableName:       "return_ticket_prices",
	TopAirlinesTableName:              "top_airlines",
	AlternativeRoutesPricesTableName:  "alternative_routes_prices",
	MedianPricesTableName:             "median_prices",
	RouteInfosTableName:               "route_infos",
	MinPricesByAirlineTableName:       "min_prices_by_airline",
	RouteCrosslinksTableName:          "route_crosslinks",
	RoutesTableName:                   "routes",
	CityToRouteCrosslinksTableName:    "city_to_route_crosslinks",
	CityToMonthAndYearPricesTableName: "month_and_year_prices_by_city_to",
	CityToNearestCitiesTableName:      "city_to_nearest_cities",
	DirectionPopularityTableName:      "recent_direction_popularity",
}

type Registry struct {
	PopularMonths            *PopularMonthsTable
	ReturnTicketPrices       *ReturnTicketPricesTable
	TopAirlines              *TopAirlinesTable
	AlternativeRoutesPrices  *AlternativeRoutesPricesTable
	MedianPrices             *MedianPricesTable
	RouteInfos               *RouteInfosTable
	MinPricesByAirline       *MinPricesByAirlineTable
	RouteCrosslinks          *RouteCrosslinksTable
	Routes                   *RoutesTable
	CityToRouteCrosslinks    *CityToRouteCrosslinksTable
	CityToMonthAndYearPrices *CityToMonthAndYearPricesTable
	CityToNearestCities      *CityToNearestCitiesTable
	SettlementPopularity     *DirectionPopularityTable
}

func NewRegistry(sessionPool *table.SessionPool, c Config) *Registry {
	return &Registry{
		PopularMonths:            NewPopularMonthsTable(sessionPool, c),
		ReturnTicketPrices:       NewReturnTicketPricesTable(sessionPool, c),
		TopAirlines:              NewTopAirlinesTable(sessionPool, c),
		AlternativeRoutesPrices:  NewAlternativeRoutesPricesTable(sessionPool, c),
		MedianPrices:             NewMedianPricesTable(sessionPool, c),
		RouteInfos:               NewRouteInfosTable(sessionPool, c),
		MinPricesByAirline:       NewMinPricesByAirlineTable(sessionPool, c),
		RouteCrosslinks:          NewRouteCrosslinksTable(sessionPool, c),
		Routes:                   NewRoutesTable(sessionPool, c),
		CityToRouteCrosslinks:    NewCityToRouteCrosslinksTable(sessionPool, c),
		CityToMonthAndYearPrices: NewCityToMonthAndYearPricesTable(sessionPool, c),
		CityToNearestCities:      NewCityToNearestCitiesTable(sessionPool, c),
		SettlementPopularity:     NewDirectionPopularityTable(sessionPool, c),
	}
}
