package tables

import "a.yandex-team.ru/kikimr/public/sdk/go/ydb/opt"

//go:generate ydbgen -wrap optional

//ydb:gen
//ydb:set wrap:none
type PopularMonthEntry struct {
	FromID          uint32 `ydb:"column:from_id,type:uint32?"`
	ToID            uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion string `ydb:"column:national_version,type:utf8?"`
	Year            uint32 `ydb:"type:uint32?"`
	Month           uint8  `ydb:"type:uint8?"`
	Price           uint32 `ydb:"type:uint32?"`
	Currency        string `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type PopularMonthEntries []PopularMonthEntry

//ydb:gen
//ydb:set wrap:none
type ReturnTicketPriceEntry struct {
	FromID          uint32 `ydb:"column:from_id,type:uint32?"`
	ToID            uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion string `ydb:"column:national_version,type:utf8?"`
	Price           uint32 `ydb:"type:uint32?"`
	Currency        string `ydb:"type:utf8?"`
	Date            string `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type ReturnTicketPriceEntries []ReturnTicketPriceEntry

//ydb:gen
//ydb:set wrap:none
type TopAirlinesEntry struct {
	FromID          uint32 `ydb:"column:from_id,type:uint32?"`
	ToID            uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion string `ydb:"column:national_version,type:utf8?"`
	TopAirlines     string `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type TopAirlinesEntries []TopAirlinesEntry

//ydb:gen
//ydb:set wrap:none
type DirectionPopularityEntry struct {
	SettlementFromID uint32 `ydb:"column:settlement_from_id,type:uint32?"`
	SettlementToID   uint32 `ydb:"column:settlement_to_id,type:uint32?"`
	RedirNumber      uint32 `ydb:"column:redir_number,type:uint32?"`
}

//ydb:gen scan,value
type DirectionPopularityEntries []DirectionPopularityEntry

//ydb:gen
//ydb:set wrap:none
type AlternativeRoutePriceEntry struct {
	FromID          uint32 `ydb:"column:from_id,type:uint32?"`
	ToID            uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion string `ydb:"column:national_version,type:utf8?"`
	AlternativeToID uint32 `ydb:"column:alternative_to_id,type:uint32?"`
	Price           uint32 `ydb:"type:uint32?"`
	Currency        string `ydb:"type:utf8?"`
	Date            string `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type AlternativeRoutePricesEntries []AlternativeRoutePriceEntry

//ydb:gen
//ydb:set wrap:none
type MedianPricesEntry struct {
	FromID           uint32 `ydb:"column:from_id,type:uint32?"`
	ToID             uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion  string `ydb:"column:national_version,type:utf8?"`
	Month            uint8  `ydb:"column:month,type:uint8?"`
	Year             uint32 `ydb:"column:year,type:uint32?"`
	MonthMedianPrice uint32 `ydb:"column:month_median_price,type:uint32?"`
	YearMedianPrice  uint32 `ydb:"column:year_median_price,type:uint32?"`
	Currency         string `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type MedianPricesEntries []MedianPricesEntry

//ydb:gen
//ydb:set wrap:none
type RouteInfoEntry struct {
	FromID       uint32 `ydb:"column:from_id,type:uint32?"`
	ToID         uint32 `ydb:"column:to_id,type:uint32?"`
	Distance     uint32 `ydb:"column:distance,type:uint32?"`
	Duration     uint32 `ydb:"column:duration,type:uint32?"`
	FromAirports string `ydb:"column:from_airports,type:string?"`
	ToAirports   string `ydb:"column:to_airports,type:string?"`
}

//ydb:gen scan,value
type RouteInfoEntries []RouteInfoEntry

//ydb:gen
//ydb:set wrap:none
type RouteEntry struct {
	FromID          uint32 `ydb:"column:from_id,type:uint32?"`
	ToID            uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion string `ydb:"column:national_version,type:utf8?"`
}

//ydb:gen scan,value
type RouteEntries []RouteEntry

//ydb:gen
//ydb:set wrap:none
type MinPriceByAirlineEntry struct {
	FromID                     uint32     `ydb:"column:from_id,type:uint32?"`
	ToID                       uint32     `ydb:"column:to_id,type:uint32?"`
	NationalVersion            string     `ydb:"column:national_version,type:utf8?"`
	AirlineID                  uint32     `ydb:"column:airline_id,type:uint32?"`
	MinPrice                   opt.Uint32 `ydb:"column:min_price,type:uint32?"`
	DepartureDate              opt.String `ydb:"column:departure_date,type:utf8?"`
	MinPriceWithTransfers      opt.Uint32 `ydb:"column:min_price_with_transfers,type:uint32?"`
	DepartureDateWithTransfers opt.String `ydb:"column:departure_date_with_transfers,type:utf8?"`
	Currency                   string     `ydb:"column:currency,type:utf8?"`
}

//ydb:gen scan,value
type MinPriceByAirlineEntries []MinPriceByAirlineEntry

//ydb:gen
//ydb:set wrap:none
type RouteCrosslinkEntry struct {
	FromID          uint32     `ydb:"column:from_id,type:uint32?"`
	ToID            uint32     `ydb:"column:to_id,type:uint32?"`
	NationalVersion string     `ydb:"column:national_version,type:utf8?"`
	Position        uint8      `ydb:"column:position,type:uint8?"`
	CrosslinkFromID uint32     `ydb:"column:crosslink_from_id,type:uint32?"`
	CrosslinkToID   uint32     `ydb:"column:crosslink_to_id,type:uint32?"`
	Price           opt.Uint32 `ydb:"type:uint32?"`
	Currency        opt.String `ydb:"type:utf8?"`
	Date            opt.String `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type RouteCrosslinkEntries []RouteCrosslinkEntry

//ydb:gen
//ydb:set wrap:none
type CityToRouteCrosslinkEntry struct {
	ToID            uint32     `ydb:"column:to_id,type:uint32?"`
	NationalVersion string     `ydb:"column:national_version,type:utf8?"`
	Position        uint8      `ydb:"column:position,type:uint8?"`
	CrosslinkFromID uint32     `ydb:"column:crosslink_from_id,type:uint32?"`
	CrosslinkToID   uint32     `ydb:"column:crosslink_to_id,type:uint32?"`
	Price           opt.Uint32 `ydb:"type:uint32?"`
	Currency        opt.String `ydb:"type:utf8?"`
	Date            opt.String `ydb:"type:utf8?"`
}

//ydb:gen scan,value
type CityToRouteCrosslinkEntries []CityToRouteCrosslinkEntry

//ydb:gen
//ydb:set wrap:none
type CityToMonthAndYearPricesEntry struct {
	ToID                    uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion         string `ydb:"column:national_version,type:utf8?"`
	Currency                string `ydb:"column:currency,type:utf8?"`
	YearMedianPrice         uint32 `ydb:"column:year_median_price,type:uint32?"`
	PopularMonthYear        uint32 `ydb:"column:popular_month_year,type:uint32?"`
	PopularMonth            uint8  `ydb:"column:popular_month,type:uint8?"`
	PopularMonthMedianPrice uint32 `ydb:"column:popular_month_median_price,type:uint32?"`
	MinMonthYear            uint32 `ydb:"column:min_month_year,type:uint32?"`
	MinMonth                uint8  `ydb:"column:min_month,type:uint8?"`
	MinMonthMedianPrice     uint32 `ydb:"column:min_month_median_price,type:uint32?"`
	MaxMonthYear            uint32 `ydb:"column:max_month_year,type:uint32?"`
	MaxMonth                uint8  `ydb:"column:max_month,type:uint8?"`
	MaxMonthMedianPrice     uint32 `ydb:"column:max_month_median_price,type:uint32?"`
}

//ydb:gen scan,value
type CityToMonthAndYearPricesEntries []CityToMonthAndYearPricesEntry

//ydb:gen
//ydb:set wrap:none
type CityToNearestCitiesEntry struct {
	ToID            uint32 `ydb:"column:to_id,type:uint32?"`
	NationalVersion string `ydb:"column:national_version,type:utf8?"`
	NearestCityIds  string `ydb:"column:nearest_city_ids,type:utf8?"`
}

//ydb:gen scan,value
type CityToNearestCitiesEntries []CityToNearestCitiesEntry
