GO_LIBRARY()

OWNER(g:avia)

SET(
    source_dir
    travel/avia/avia_statistics/api/internal/pkg/tables
)

RUN_PROGRAM(
    kikimr/public/sdk/go/ydb/cmd/ydbgen
    -dir=${ARCADIA_ROOT}/${source_dir}
    -out=${ARCADIA_BUILD_ROOT}/${source_dir}
    -goroot=${GO_TOOLS_ROOT}
    -lookup=a.yandex-team.ru:${ARCADIA_ROOT}
    -force
    IN
    ${ARCADIA_ROOT}/${source_dir}/types.go
    OUT
    ${ARCADIA_BUILD_ROOT}/${source_dir}/types_ydbgen.go
    ENV
    GO111MODULE=off
)

INCLUDE(${ARCADIA_ROOT}/kikimr/public/sdk/go/ydb/cmd/ydbgen/ydbgen_generated_deps.inc)

SRCS(
    alternative_routes_prices.go
    city_to_nearest_cities.go
    city_to_route_crosslinks.go
    direction_popularity.go
    median_prices.go
    min_prices_by_airline.go
    month_and_year_prices_by_city_to.go
    popular_months.go
    registry.go
    return_ticket_prices.go
    route_crosslinks.go
    route_infos.go
    routes.go
    top_airlines.go
    types.go
)

END()
