package updating

import (
	"reflect"
	"time"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/metrics"
)

type BackgroundUpdater struct {
	logger log.Logger
}

func NewBackgroundUpdater(logger log.Logger) *BackgroundUpdater {
	return &BackgroundUpdater{logger: logger}
}

func (u BackgroundUpdater) RunBackgroundUpdates(repositoryType string, update func() error,
	updateInterval time.Duration) {
	go func() {
		for range time.Tick(updateInterval) {
			if err := update(); err != nil {
				metrics.GlobalAppMetrics().GetOrCreateCounter(
					"background_data_update",
					map[string]string{"type": repositoryType},
					"error",
				)
				u.logger.Errorf("can't update %s: %+v", repositoryType, err)
			}
		}
	}()
}

func TypeToString(t reflect.Type) string {
	if t.Kind() == reflect.Ptr {
		return t.Elem().String()
	}
	return t.String()
}
