package handler

import (
	"context"
	"time"

	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/avia/avia_statistics/api/internal/seolanding/models"
	"a.yandex-team.ru/travel/avia/avia_statistics/api/internal/seolanding/service/landings"
)

type LandingBuilder interface {
	Build(context.Context, *landings.Query) (*models.Landing, error)
}

const metricsPrefix = "landing_route"

var timingBuckets = metrics.MakeExponentialDurationBuckets(time.Millisecond, 1.4, 20)
