package models

import (
	"errors"
)

var ErrorNotFound = errors.New("NotFound")

type Landing struct {
	FromID                  uint32                  `json:"fromId"`
	ToID                    uint32                  `json:"toId"`
	PopularMonth            *PopularMonth           `json:"popularMonth,omitempty"`
	ReturnTicketPrice       *ReturnTicketPrice      `json:"returnTicketPrice,omitempty"`
	AlternativeRoutesPrices []AlternativeRoutePrice `json:"alternativeRoutesPrices"`
	MedianPrices            *MedianPrices           `json:"medianPrices"`
	RouteInfo               *RouteInfo              `json:"routeInfo"`
	TopAirlines             []AirlineWithPrice      `json:"topAirlines"`
	RouteCrosslinks         []RouteCrosslink        `json:"routeCrosslinks"`
}

type AirlineWithPrice struct {
	ID                         uint32  `json:"id"`
	Price                      *uint32 `json:"price"`
	DepartureDate              *string `json:"departureDate"`
	PriceWithTransfers         *uint32 `json:"priceWithTransfers"`
	DepartureDateWithTransfers *string `json:"departureDateWithTransfers"`
	Currency                   string  `json:"currency"`
}

type PopularMonth struct {
	FromID          uint32 `json:"-"`
	ToID            uint32 `json:"-"`
	NationalVersion string `json:"-"`
	Year            uint32 `json:"year"`
	Month           uint8  `json:"month"`
	Price           uint32 `json:"price"`
	Currency        string `json:"currency"`
}

type ReturnTicketPrice struct {
	FromID          uint32 `json:"-"`
	ToID            uint32 `json:"-"`
	NationalVersion string `json:"-"`
	Price           uint32 `json:"price"`
	Currency        string `json:"currency"`
	Date            string `json:"date"`
}

type TopAirlines struct {
	FromID          uint32   `json:"-"`
	ToID            uint32   `json:"-"`
	NationalVersion string   `json:"-"`
	TopAirlines     []uint32 `json:"topAirlines"`
}

type AlternativeRoutePrice struct {
	FromID          uint32 `json:"-"`
	ToID            uint32 `json:"-"`
	NationalVersion string `json:"-"`
	AlternativeToID uint32 `json:"alternativeToId"`
	Price           uint32 `json:"price"`
	Currency        string `json:"currency"`
	Date            string `json:"date"`
}

type MedianPrices struct {
	FromID           uint32 `json:"-"`
	ToID             uint32 `json:"-"`
	NationalVersion  string `json:"-"`
	Month            uint8  `json:"month"`
	Year             uint32 `json:"year"`
	MonthMedianPrice uint32 `json:"monthMedianPrice"`
	YearMedianPrice  uint32 `json:"yearMedianPrice"`
	Currency         string `json:"currency"`
}

type RouteInfo struct {
	FromID       uint32 `json:"-"`
	ToID         uint32 `json:"-"`
	Distance     uint32 `json:"distance"`
	Duration     uint32 `json:"duration"`
	FromAirports []int  `json:"fromAirports"`
	ToAirports   []int  `json:"toAirports"`
}

type Route struct {
	FromID          uint32 `json:"from_id"`
	ToID            uint32 `json:"to_id"`
	NationalVersion string `json:"national_version"`
}

type MinPriceByAirline struct {
	FromID                     uint32  `json:"-"`
	ToID                       uint32  `json:"-"`
	NationalVersion            string  `json:"-"`
	AirlineID                  uint32  `json:"airlineId"`
	MinPrice                   *uint32 `json:"minPrice"`
	DepartureDate              *string `json:"departureDate"`
	MinPriceWithTransfers      *uint32 `json:"minPriceWithTransfers"`
	DepartureDateWithTransfers *string `json:"departureDateWithTransfers"`
	Currency                   string  `json:"currency"`
}

type RouteCrosslink struct {
	FromID          uint32  `json:"-"`
	ToID            uint32  `json:"-"`
	NationalVersion string  `json:"-"`
	CrosslinkFromID uint32  `json:"crosslinkFromId"`
	CrosslinkToID   uint32  `json:"crosslinkToId"`
	Price           *uint32 `json:"price"`
	Currency        *string `json:"currency"`
	Date            *string `json:"date"`
}
