from collections import namedtuple
from typing import Generator

from yt.wrapper import YtClient

CITIES_TABLE = '//home/avia/avia-statistics/city-to-landing-cities'

LandingCity = namedtuple('LandingCity', ('to_id', 'national_version'))
LandingRoute = namedtuple('LandingRoute', ('from_id', 'to_id', 'national_version'))


def iter_landing_cities(yt_client, path=CITIES_TABLE):
    # type: (YtClient, str) -> Generator[LandingCity]
    cities = yt_client.read_table(path)
    for city in cities:
        yield LandingCity(
            to_id=city['id'],
            national_version='ru',
        )
