# -*- coding: utf-8 -*-
import logging
from datetime import datetime, date
from argparse import ArgumentParser

import ydb

from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.avia_statistics.return_ticket_prices_updater.lib.updater import ReturnTicketPricesUpdater
from travel.avia.avia_statistics.return_ticket_prices_updater.lib.table import ReturnTicketPriceTable
from travel.avia.avia_statistics.services.price_index.client import Client as PriceIndexClient
from travel.avia.avia_statistics.landing_routes import get_landing_routes
from travel.avia.library.python.ydb.session_manager import YdbSessionManager


def main():
    parser = ArgumentParser()

    parser.add_argument('--debug', action='store_true', default=False)
    parser.add_argument('--price-index-host', help='price-index host',
                        default='http://price-index.production.avia.yandex.net')

    parser.add_argument('--yt-token', help='YT token', required=True)
    parser.add_argument('--yt-proxy', default='hahn')

    parser.add_argument('--ydb-cluster', default='ydb-ru-prestable.yandex.net:2135')
    parser.add_argument('--ydb-database', default='/ru-prestable/ticket/testing/avia_statistics')
    parser.add_argument('--ydb-table', default='return_ticket_prices')
    parser.add_argument('--ydb-token', help='YDB token', required=True)

    parser.add_argument('--batch', help='Batch size', default=100)
    parser.add_argument('--window-size', help='Price searching window size in the future', default=30)
    parser.add_argument('--date', help='Date', default=date.today().isoformat())

    arguments = parser.parse_args()

    logging.basicConfig(level=logging.INFO)

    if arguments.debug:
        logging.basicConfig(level=logging.DEBUG)

    yt_client = configured_client(proxy=arguments.yt_proxy, token=arguments.yt_token)
    ydb_config = ydb.DriverConfig(
        endpoint=arguments.ydb_cluster,
        database=arguments.ydb_database,
        auth_token=arguments.ydb_token,
    )
    session_manager = YdbSessionManager(ydb_config)

    return_ticket_price_table = ReturnTicketPriceTable(session_manager, arguments.ydb_database, arguments.ydb_table)
    price_index_client = PriceIndexClient(arguments.price_index_host)
    landing_routes = get_landing_routes(yt_client)
    return_ticket_price_updater = ReturnTicketPricesUpdater(
        landing_routes,
        return_ticket_price_table,
        price_index_client,
        arguments.batch,
    )
    target_date = datetime.strptime(arguments.date, '%Y-%m-%d')
    return_ticket_price_updater.update_return_ticket_prices(target_date, arguments.window_size)


if __name__ == '__main__':
    main()
