# -*- coding: utf-8 -*-
import logging
from argparse import ArgumentParser

import ydb

from travel.avia.library.python.lib_yt.client import configured_client
from travel.avia.avia_statistics.routes_updater.lib.updater import RoutesUpdater
from travel.avia.avia_statistics.routes_updater.lib.table import RoutesTable
from travel.avia.avia_statistics.landing_routes import get_landing_routes
from travel.avia.library.python.ydb.session_manager import YdbSessionManager

logger = logging.getLogger(__name__)


def main():
    parser = ArgumentParser()

    parser.add_argument('--debug', action='store_true', default=False)

    parser.add_argument('--yt-token', help='YT token', required=True)
    parser.add_argument('--yt-proxy', default='hahn')

    parser.add_argument('--ydb-cluster', default='ydb-ru-prestable.yandex.net:2135')
    parser.add_argument('--ydb-database', default='/ru-prestable/ticket/testing/avia_statistics')
    parser.add_argument('--ydb-table', default='routes')
    parser.add_argument('--ydb-token', help='YDB token', required=True)

    parser.add_argument('--batch', help='Batch size', default=100)

    arguments = parser.parse_args()

    logging.basicConfig(level=logging.INFO)

    if arguments.debug:
        logging.basicConfig(level=logging.DEBUG)

    yt_client = configured_client(proxy=arguments.yt_proxy, token=arguments.yt_token)
    ydb_config = ydb.DriverConfig(
        endpoint=arguments.ydb_cluster,
        database=arguments.ydb_database,
        auth_token=arguments.ydb_token,
    )
    session_manager = YdbSessionManager(ydb_config)

    routes_table = RoutesTable(session_manager, arguments.ydb_database, arguments.ydb_table)
    landing_routes = get_landing_routes(yt_client)
    routes_updater = RoutesUpdater(
        landing_routes,
        routes_table,
        arguments.batch,
    )
    routes_updater.update()


if __name__ == '__main__':
    main()
